@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ACRPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class for ACR Properties.
 * @property registryName Gets or sets the azure container registry name.
 * @property resourceGroup Gets or sets the resource group of the resource.
 * @property subscriptionId Gets or sets the subscription id of the resource.
 * @property tenantId Gets or sets the tenant id.
 */
public data class ACRPropertiesArgs(
    public val registryName: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ACRPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ACRPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ACRPropertiesArgs.builder()
            .registryName(registryName?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ACRPropertiesArgs].
 */
@PulumiTagMarker
public class ACRPropertiesArgsBuilder internal constructor() {
    private var registryName: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Gets or sets the azure container registry name.
     */
    @JvmName("snafpoqmnblqkpgb")
    public suspend fun registryName(`value`: Output<String>) {
        this.registryName = value
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("ltaygqtquehjyfkk")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("jqdteqrxjyrtacjt")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("dwlkxlahrlqobrqj")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Gets or sets the azure container registry name.
     */
    @JvmName("bnsdtpwskrjelqly")
    public suspend fun registryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryName = mapped
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("lfbgwirikenumuah")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("paooxoxscijiynfw")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Gets or sets the tenant id.
     */
    @JvmName("vgdloeigsxwdrvtu")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ACRPropertiesArgs = ACRPropertiesArgs(
        registryName = registryName,
        resourceGroup = resourceGroup,
        subscriptionId = subscriptionId,
        tenantId = tenantId,
    )
}
