@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ApacheTomcat web application.
 * @property automationArtifactProperties Class for automation artifact.
 * @property bindings Gets or sets the bindings for the application.
 * @property buildContainerImages Gets or sets the build container images.
 * @property clusterProperties Class for AKSDeployment Properties.
 * @property configurations Gets or sets application configuration.
 * @property containerImageProperties Class for container image properties.
 * @property deploymentNamePrefix Gets or sets the deployment name prefix.
 * @property deploymentSpec AKS Deployment Specification.
 * @property directories Gets or sets application directories.
 * @property limits Resource Requirements.
 * @property monitoringProperties Class for app insight monitoring properties.
 * @property requests Resource Requirements.
 * @property targetPlatformIdentity Gets or sets the target platform managed identity.
 */
public data class ApacheTomcatAKSWorkloadDeploymentArgs(
    public val automationArtifactProperties: Output<AutomationArtifactArgs>? = null,
    public val bindings: Output<List<BindingArgs>>? = null,
    public val buildContainerImages: Output<List<ContainerImagePropertiesArgs>>? = null,
    public val clusterProperties: Output<AKSDeploymentPropertiesArgs>? = null,
    public val configurations: Output<List<WebApplicationConfigurationArgs>>? = null,
    public val containerImageProperties: Output<ContainerImagePropertiesArgs>? = null,
    public val deploymentNamePrefix: Output<String>? = null,
    public val deploymentSpec: Output<AKSDeploymentSpecificationArgs>? = null,
    public val directories: Output<List<WebApplicationDirectoryArgs>>? = null,
    public val limits: Output<ResourceRequirementsArgs>? = null,
    public val monitoringProperties: Output<AppInsightMonitoringPropertiesArgs>? = null,
    public val requests: Output<ResourceRequirementsArgs>? = null,
    public val targetPlatformIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentArgs =
        com.pulumi.azurenative.migrate.inputs.ApacheTomcatAKSWorkloadDeploymentArgs.builder()
            .automationArtifactProperties(
                automationArtifactProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .bindings(
                bindings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .buildContainerImages(
                buildContainerImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .clusterProperties(clusterProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .containerImageProperties(
                containerImageProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deploymentNamePrefix(deploymentNamePrefix?.applyValue({ args0 -> args0 }))
            .deploymentSpec(deploymentSpec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .limits(limits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .monitoringProperties(
                monitoringProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requests(requests?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .targetPlatformIdentity(targetPlatformIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApacheTomcatAKSWorkloadDeploymentArgs].
 */
@PulumiTagMarker
public class ApacheTomcatAKSWorkloadDeploymentArgsBuilder internal constructor() {
    private var automationArtifactProperties: Output<AutomationArtifactArgs>? = null

    private var bindings: Output<List<BindingArgs>>? = null

    private var buildContainerImages: Output<List<ContainerImagePropertiesArgs>>? = null

    private var clusterProperties: Output<AKSDeploymentPropertiesArgs>? = null

    private var configurations: Output<List<WebApplicationConfigurationArgs>>? = null

    private var containerImageProperties: Output<ContainerImagePropertiesArgs>? = null

    private var deploymentNamePrefix: Output<String>? = null

    private var deploymentSpec: Output<AKSDeploymentSpecificationArgs>? = null

    private var directories: Output<List<WebApplicationDirectoryArgs>>? = null

    private var limits: Output<ResourceRequirementsArgs>? = null

    private var monitoringProperties: Output<AppInsightMonitoringPropertiesArgs>? = null

    private var requests: Output<ResourceRequirementsArgs>? = null

    private var targetPlatformIdentity: Output<String>? = null

    /**
     * @param value Class for automation artifact.
     */
    @JvmName("crdxymgdueuyijun")
    public suspend fun automationArtifactProperties(`value`: Output<AutomationArtifactArgs>) {
        this.automationArtifactProperties = value
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("ywckqqoqkgnrdtow")
    public suspend fun bindings(`value`: Output<List<BindingArgs>>) {
        this.bindings = value
    }

    @JvmName("khmyrwoanykeovgk")
    public suspend fun bindings(vararg values: Output<BindingArgs>) {
        this.bindings = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("gaosurrpaxhqopdu")
    public suspend fun bindings(values: List<Output<BindingArgs>>) {
        this.bindings = Output.all(values)
    }

    /**
     * @param value Gets or sets the build container images.
     */
    @JvmName("sxeqcqkgubcyahak")
    public suspend fun buildContainerImages(`value`: Output<List<ContainerImagePropertiesArgs>>) {
        this.buildContainerImages = value
    }

    @JvmName("lkjbgbrkgfvhdtmh")
    public suspend fun buildContainerImages(vararg values: Output<ContainerImagePropertiesArgs>) {
        this.buildContainerImages = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the build container images.
     */
    @JvmName("urhdsavygwxvrptc")
    public suspend fun buildContainerImages(values: List<Output<ContainerImagePropertiesArgs>>) {
        this.buildContainerImages = Output.all(values)
    }

    /**
     * @param value Class for AKSDeployment Properties.
     */
    @JvmName("kxyohbdptibhtbum")
    public suspend fun clusterProperties(`value`: Output<AKSDeploymentPropertiesArgs>) {
        this.clusterProperties = value
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("ddlojpacvsdboynx")
    public suspend fun configurations(`value`: Output<List<WebApplicationConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("gnfoynmfpadcpsjy")
    public suspend fun configurations(vararg values: Output<WebApplicationConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("sqcbpmyjmbhetodj")
    public suspend fun configurations(values: List<Output<WebApplicationConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Class for container image properties.
     */
    @JvmName("vajkpstqgkydkcly")
    public suspend fun containerImageProperties(`value`: Output<ContainerImagePropertiesArgs>) {
        this.containerImageProperties = value
    }

    /**
     * @param value Gets or sets the deployment name prefix.
     */
    @JvmName("rrqvutewaqegxsjm")
    public suspend fun deploymentNamePrefix(`value`: Output<String>) {
        this.deploymentNamePrefix = value
    }

    /**
     * @param value AKS Deployment Specification.
     */
    @JvmName("ootsoxqlpwxkosgm")
    public suspend fun deploymentSpec(`value`: Output<AKSDeploymentSpecificationArgs>) {
        this.deploymentSpec = value
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("bvyaivvywwvlhmqc")
    public suspend fun directories(`value`: Output<List<WebApplicationDirectoryArgs>>) {
        this.directories = value
    }

    @JvmName("xodaldufshmimvmv")
    public suspend fun directories(vararg values: Output<WebApplicationDirectoryArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("hvqrrrmdmbwpvyeq")
    public suspend fun directories(values: List<Output<WebApplicationDirectoryArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("ctduerimuuadisgu")
    public suspend fun limits(`value`: Output<ResourceRequirementsArgs>) {
        this.limits = value
    }

    /**
     * @param value Class for app insight monitoring properties.
     */
    @JvmName("vielijbjtmyknoky")
    public suspend fun monitoringProperties(`value`: Output<AppInsightMonitoringPropertiesArgs>) {
        this.monitoringProperties = value
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("nqebsmgcykclbenw")
    public suspend fun requests(`value`: Output<ResourceRequirementsArgs>) {
        this.requests = value
    }

    /**
     * @param value Gets or sets the target platform managed identity.
     */
    @JvmName("eoxlwqimmmewnhbg")
    public suspend fun targetPlatformIdentity(`value`: Output<String>) {
        this.targetPlatformIdentity = value
    }

    /**
     * @param value Class for automation artifact.
     */
    @JvmName("gohcrqvuyxfsdvmn")
    public suspend fun automationArtifactProperties(`value`: AutomationArtifactArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automationArtifactProperties = mapped
    }

    /**
     * @param argument Class for automation artifact.
     */
    @JvmName("wisfpbebsifvvdyq")
    public suspend
    fun automationArtifactProperties(argument: suspend AutomationArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = AutomationArtifactArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.automationArtifactProperties = mapped
    }

    /**
     * @param value Gets or sets the bindings for the application.
     */
    @JvmName("ypnbbfvmxvqqvpwo")
    public suspend fun bindings(`value`: List<BindingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("qdceumihqdqnsfhe")
    public suspend fun bindings(argument: List<suspend BindingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("cxrtxdpcptjdtehm")
    public suspend fun bindings(vararg argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BindingArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param argument Gets or sets the bindings for the application.
     */
    @JvmName("ldhyxrpxkgahatgu")
    public suspend fun bindings(argument: suspend BindingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BindingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindings = mapped
    }

    /**
     * @param values Gets or sets the bindings for the application.
     */
    @JvmName("sqrbtlfdghcrqvpk")
    public suspend fun bindings(vararg values: BindingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindings = mapped
    }

    /**
     * @param value Gets or sets the build container images.
     */
    @JvmName("lgcrfyayhgqnerme")
    public suspend fun buildContainerImages(`value`: List<ContainerImagePropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildContainerImages = mapped
    }

    /**
     * @param argument Gets or sets the build container images.
     */
    @JvmName("mebjapxidempxnqx")
    public suspend
    fun buildContainerImages(argument: List<suspend ContainerImagePropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerImagePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildContainerImages = mapped
    }

    /**
     * @param argument Gets or sets the build container images.
     */
    @JvmName("vdlkrjitkhkyjomg")
    public suspend fun buildContainerImages(
        vararg
        argument: suspend ContainerImagePropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ContainerImagePropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buildContainerImages = mapped
    }

    /**
     * @param argument Gets or sets the build container images.
     */
    @JvmName("gkrgcsbeywilwodh")
    public suspend
    fun buildContainerImages(argument: suspend ContainerImagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ContainerImagePropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.buildContainerImages = mapped
    }

    /**
     * @param values Gets or sets the build container images.
     */
    @JvmName("mwbdbmsdldcescfc")
    public suspend fun buildContainerImages(vararg values: ContainerImagePropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buildContainerImages = mapped
    }

    /**
     * @param value Class for AKSDeployment Properties.
     */
    @JvmName("qlqbgqwosojwucku")
    public suspend fun clusterProperties(`value`: AKSDeploymentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterProperties = mapped
    }

    /**
     * @param argument Class for AKSDeployment Properties.
     */
    @JvmName("bhvqmqasacuguwlg")
    public suspend
    fun clusterProperties(argument: suspend AKSDeploymentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AKSDeploymentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clusterProperties = mapped
    }

    /**
     * @param value Gets or sets application configuration.
     */
    @JvmName("urndjpyeagwyibld")
    public suspend fun configurations(`value`: List<WebApplicationConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("nkjddjyjvceehsxa")
    public suspend
    fun configurations(argument: List<suspend WebApplicationConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("tynadjswxsvpadkh")
    public suspend fun configurations(
        vararg
        argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Gets or sets application configuration.
     */
    @JvmName("xhlfwqfalkjotkqk")
    public suspend
    fun configurations(argument: suspend WebApplicationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Gets or sets application configuration.
     */
    @JvmName("ldueoelevbntqylh")
    public suspend fun configurations(vararg values: WebApplicationConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Class for container image properties.
     */
    @JvmName("aksyqjjaetggmomg")
    public suspend fun containerImageProperties(`value`: ContainerImagePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerImageProperties = mapped
    }

    /**
     * @param argument Class for container image properties.
     */
    @JvmName("shljxwpdfdkbtotq")
    public suspend
    fun containerImageProperties(argument: suspend ContainerImagePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImagePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerImageProperties = mapped
    }

    /**
     * @param value Gets or sets the deployment name prefix.
     */
    @JvmName("xrtgcgwamvrbnejd")
    public suspend fun deploymentNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentNamePrefix = mapped
    }

    /**
     * @param value AKS Deployment Specification.
     */
    @JvmName("sglelkgejfvvytjp")
    public suspend fun deploymentSpec(`value`: AKSDeploymentSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentSpec = mapped
    }

    /**
     * @param argument AKS Deployment Specification.
     */
    @JvmName("ywgtvgpdebrlwixh")
    public suspend
    fun deploymentSpec(argument: suspend AKSDeploymentSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = AKSDeploymentSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentSpec = mapped
    }

    /**
     * @param value Gets or sets application directories.
     */
    @JvmName("qcuyapylelnjrkvg")
    public suspend fun directories(`value`: List<WebApplicationDirectoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("mkepeeylpdbvtejk")
    public suspend
    fun directories(argument: List<suspend WebApplicationDirectoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("rvralliawxxyyile")
    public suspend fun directories(
        vararg
        argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            WebApplicationDirectoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets application directories.
     */
    @JvmName("ucqmxylfkmvgoknc")
    public suspend fun directories(argument: suspend WebApplicationDirectoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WebApplicationDirectoryArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets application directories.
     */
    @JvmName("pvraogoqrfbkbsbi")
    public suspend fun directories(vararg values: WebApplicationDirectoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("orecbetfquvihlgv")
    public suspend fun limits(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.limits = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("qdnxjvoshceojlsc")
    public suspend fun limits(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.limits = mapped
    }

    /**
     * @param value Class for app insight monitoring properties.
     */
    @JvmName("axkriaqyhvpqnhhq")
    public suspend fun monitoringProperties(`value`: AppInsightMonitoringPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoringProperties = mapped
    }

    /**
     * @param argument Class for app insight monitoring properties.
     */
    @JvmName("fhljubjqrturvmrt")
    public suspend
    fun monitoringProperties(argument: suspend AppInsightMonitoringPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AppInsightMonitoringPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.monitoringProperties = mapped
    }

    /**
     * @param value Resource Requirements.
     */
    @JvmName("vqudgpixvxdrpxpr")
    public suspend fun requests(`value`: ResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requests = mapped
    }

    /**
     * @param argument Resource Requirements.
     */
    @JvmName("amwhlgfqrbtdorkx")
    public suspend fun requests(argument: suspend ResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.requests = mapped
    }

    /**
     * @param value Gets or sets the target platform managed identity.
     */
    @JvmName("wjmptsnlkktiyfqh")
    public suspend fun targetPlatformIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPlatformIdentity = mapped
    }

    internal fun build(): ApacheTomcatAKSWorkloadDeploymentArgs =
        ApacheTomcatAKSWorkloadDeploymentArgs(
            automationArtifactProperties = automationArtifactProperties,
            bindings = bindings,
            buildContainerImages = buildContainerImages,
            clusterProperties = clusterProperties,
            configurations = configurations,
            containerImageProperties = containerImageProperties,
            deploymentNamePrefix = deploymentNamePrefix,
            deploymentSpec = deploymentSpec,
            directories = directories,
            limits = limits,
            monitoringProperties = monitoringProperties,
            requests = requests,
            targetPlatformIdentity = targetPlatformIdentity,
        )
}
