@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AppInsightMonitoringPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Class for app insight monitoring properties.
 * @property appInsightsName Gets or sets the app insights name.
 * @property isEnabled Gets or sets a value indicating whether monitoring is enabled.
 * @property region Gets or sets the region.
 * @property resourceGroup Gets or sets the resource group of the resource.
 * @property secretStoreDetails
 * @property subscriptionId Gets or sets the subscription id of the resource.
 */
public data class AppInsightMonitoringPropertiesArgs(
    public val appInsightsName: Output<String>? = null,
    public val isEnabled: Output<Boolean>? = null,
    public val region: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val secretStoreDetails: Output<SecretStoreDetailsArgs>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AppInsightMonitoringPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AppInsightMonitoringPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.AppInsightMonitoringPropertiesArgs.builder()
            .appInsightsName(appInsightsName?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .region(region?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .secretStoreDetails(
                secretStoreDetails?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppInsightMonitoringPropertiesArgs].
 */
@PulumiTagMarker
public class AppInsightMonitoringPropertiesArgsBuilder internal constructor() {
    private var appInsightsName: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var region: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var secretStoreDetails: Output<SecretStoreDetailsArgs>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Gets or sets the app insights name.
     */
    @JvmName("nvgkdqjktyqyivnc")
    public suspend fun appInsightsName(`value`: Output<String>) {
        this.appInsightsName = value
    }

    /**
     * @param value Gets or sets a value indicating whether monitoring is enabled.
     */
    @JvmName("wulypbrcrgatcnrx")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Gets or sets the region.
     */
    @JvmName("eroukarjikwkoqbu")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("sdvcbminydfwcura")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value
     */
    @JvmName("rmauhegcpvbfocgo")
    public suspend fun secretStoreDetails(`value`: Output<SecretStoreDetailsArgs>) {
        this.secretStoreDetails = value
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("fodegmfqiiulpydj")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Gets or sets the app insights name.
     */
    @JvmName("wegstcdejbpbkoki")
    public suspend fun appInsightsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appInsightsName = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether monitoring is enabled.
     */
    @JvmName("nsjptuslqrqcaqrq")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value Gets or sets the region.
     */
    @JvmName("ccwbckmxawfuoaow")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.region = mapped
    }

    /**
     * @param value Gets or sets the resource group of the resource.
     */
    @JvmName("cwjeokgafydaixrv")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value
     */
    @JvmName("gomtxyrnwksiphpn")
    public suspend fun secretStoreDetails(`value`: SecretStoreDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vhcvwbtccduyvrrt")
    public suspend
    fun secretStoreDetails(argument: suspend SecretStoreDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStoreDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStoreDetails = mapped
    }

    /**
     * @param value Gets or sets the subscription id of the resource.
     */
    @JvmName("bekttusryswbmdwm")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): AppInsightMonitoringPropertiesArgs = AppInsightMonitoringPropertiesArgs(
        appInsightsName = appInsightsName,
        isEnabled = isEnabled,
        region = region,
        resourceGroup = resourceGroup,
        secretStoreDetails = secretStoreDetails,
        subscriptionId = subscriptionId,
    )
}
