@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentSizingCriterion
import com.pulumi.azurenative.migrate.kotlin.enums.AssessmentStage
import com.pulumi.azurenative.migrate.kotlin.enums.AzureDiskType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureHybridUseBenefit
import com.pulumi.azurenative.migrate.kotlin.enums.AzureLocation
import com.pulumi.azurenative.migrate.kotlin.enums.AzureOfferCode
import com.pulumi.azurenative.migrate.kotlin.enums.AzurePricingTier
import com.pulumi.azurenative.migrate.kotlin.enums.AzureStorageRedundancy
import com.pulumi.azurenative.migrate.kotlin.enums.AzureVmFamily
import com.pulumi.azurenative.migrate.kotlin.enums.Currency
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.ReservedInstance
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of an assessment.
 * @property azureDiskType Storage type selected for this disk.
 * @property azureHybridUseBenefit AHUB discount on windows virtual machines.
 * @property azureLocation Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
 * @property azureOfferCode Offer code according to which cost estimation is done.
 * @property azurePricingTier Pricing tier for Size evaluation.
 * @property azureStorageRedundancy Storage Redundancy type offered by Azure.
 * @property azureVmFamilies List of azure VM families.
 * @property currency Currency to report prices in.
 * @property discountPercentage Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
 * @property percentile Percentile of performance data used to recommend Azure size.
 * @property reservedInstance Azure reserved instance.
 * @property scalingFactor Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
 * @property sizingCriterion Assessment sizing criterion.
 * @property stage User configurable setting that describes the status of the assessment.
 * @property timeRange Time range of performance data used to recommend a size.
 * @property vmUptime Specify the duration for which the VMs are up in the on-premises environment.
 */
public data class AssessmentPropertiesArgs(
    public val azureDiskType: Output<Either<String, AzureDiskType>>,
    public val azureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>,
    public val azureLocation: Output<Either<String, AzureLocation>>,
    public val azureOfferCode: Output<Either<String, AzureOfferCode>>,
    public val azurePricingTier: Output<Either<String, AzurePricingTier>>,
    public val azureStorageRedundancy: Output<Either<String, AzureStorageRedundancy>>,
    public val azureVmFamilies: Output<List<Either<String, AzureVmFamily>>>,
    public val currency: Output<Either<String, Currency>>,
    public val discountPercentage: Output<Double>,
    public val percentile: Output<Either<String, Percentile>>,
    public val reservedInstance: Output<Either<String, ReservedInstance>>,
    public val scalingFactor: Output<Double>,
    public val sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>,
    public val stage: Output<Either<String, AssessmentStage>>,
    public val timeRange: Output<Either<String, TimeRange>>,
    public val vmUptime: Output<VmUptimeArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.AssessmentPropertiesArgs.builder()
            .azureDiskType(
                azureDiskType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureHybridUseBenefit(
                azureHybridUseBenefit.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureLocation(
                azureLocation.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureOfferCode(
                azureOfferCode.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azurePricingTier(
                azurePricingTier.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureStorageRedundancy(
                azureStorageRedundancy.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureVmFamilies(
                azureVmFamilies.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .currency(
                currency.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .discountPercentage(discountPercentage.applyValue({ args0 -> args0 }))
            .percentile(
                percentile.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .reservedInstance(
                reservedInstance.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scalingFactor(scalingFactor.applyValue({ args0 -> args0 }))
            .sizingCriterion(
                sizingCriterion.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .stage(
                stage.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timeRange(
                timeRange.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .vmUptime(vmUptime.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AssessmentPropertiesArgs].
 */
@PulumiTagMarker
public class AssessmentPropertiesArgsBuilder internal constructor() {
    private var azureDiskType: Output<Either<String, AzureDiskType>>? = null

    private var azureHybridUseBenefit: Output<Either<String, AzureHybridUseBenefit>>? = null

    private var azureLocation: Output<Either<String, AzureLocation>>? = null

    private var azureOfferCode: Output<Either<String, AzureOfferCode>>? = null

    private var azurePricingTier: Output<Either<String, AzurePricingTier>>? = null

    private var azureStorageRedundancy: Output<Either<String, AzureStorageRedundancy>>? = null

    private var azureVmFamilies: Output<List<Either<String, AzureVmFamily>>>? = null

    private var currency: Output<Either<String, Currency>>? = null

    private var discountPercentage: Output<Double>? = null

    private var percentile: Output<Either<String, Percentile>>? = null

    private var reservedInstance: Output<Either<String, ReservedInstance>>? = null

    private var scalingFactor: Output<Double>? = null

    private var sizingCriterion: Output<Either<String, AssessmentSizingCriterion>>? = null

    private var stage: Output<Either<String, AssessmentStage>>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    private var vmUptime: Output<VmUptimeArgs>? = null

    /**
     * @param value Storage type selected for this disk.
     */
    @JvmName("luwvsvfjfnrrqopu")
    public suspend fun azureDiskType(`value`: Output<Either<String, AzureDiskType>>) {
        this.azureDiskType = value
    }

    /**
     * @param value AHUB discount on windows virtual machines.
     */
    @JvmName("nblpclsuddkhajxr")
    public suspend fun azureHybridUseBenefit(`value`: Output<Either<String, AzureHybridUseBenefit>>) {
        this.azureHybridUseBenefit = value
    }

    /**
     * @param value Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
     */
    @JvmName("beqvmbwxxgdiqxbf")
    public suspend fun azureLocation(`value`: Output<Either<String, AzureLocation>>) {
        this.azureLocation = value
    }

    /**
     * @param value Offer code according to which cost estimation is done.
     */
    @JvmName("mluhrpwoshuvhivb")
    public suspend fun azureOfferCode(`value`: Output<Either<String, AzureOfferCode>>) {
        this.azureOfferCode = value
    }

    /**
     * @param value Pricing tier for Size evaluation.
     */
    @JvmName("irffxgxiccitocyb")
    public suspend fun azurePricingTier(`value`: Output<Either<String, AzurePricingTier>>) {
        this.azurePricingTier = value
    }

    /**
     * @param value Storage Redundancy type offered by Azure.
     */
    @JvmName("kdmlyvuvcuehxxts")
    public suspend
    fun azureStorageRedundancy(`value`: Output<Either<String, AzureStorageRedundancy>>) {
        this.azureStorageRedundancy = value
    }

    /**
     * @param value List of azure VM families.
     */
    @JvmName("hthrfsvttrfxjscr")
    public suspend fun azureVmFamilies(`value`: Output<List<Either<String, AzureVmFamily>>>) {
        this.azureVmFamilies = value
    }

    @JvmName("vhfxskffpfpkaise")
    public suspend fun azureVmFamilies(vararg values: Output<Either<String, AzureVmFamily>>) {
        this.azureVmFamilies = Output.all(values.asList())
    }

    /**
     * @param values List of azure VM families.
     */
    @JvmName("ggfakwcfdeykigmd")
    public suspend fun azureVmFamilies(values: List<Output<Either<String, AzureVmFamily>>>) {
        this.azureVmFamilies = Output.all(values)
    }

    /**
     * @param value Currency to report prices in.
     */
    @JvmName("tylgxvwibcchdwqc")
    public suspend fun currency(`value`: Output<Either<String, Currency>>) {
        this.currency = value
    }

    /**
     * @param value Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
     */
    @JvmName("cewkqwkorfottnrs")
    public suspend fun discountPercentage(`value`: Output<Double>) {
        this.discountPercentage = value
    }

    /**
     * @param value Percentile of performance data used to recommend Azure size.
     */
    @JvmName("ncypaenajqticeat")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Azure reserved instance.
     */
    @JvmName("ocycddrftulfseib")
    public suspend fun reservedInstance(`value`: Output<Either<String, ReservedInstance>>) {
        this.reservedInstance = value
    }

    /**
     * @param value Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
     */
    @JvmName("milbmlwxdlljfwqd")
    public suspend fun scalingFactor(`value`: Output<Double>) {
        this.scalingFactor = value
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("pdunoeygcyanxtym")
    public suspend fun sizingCriterion(`value`: Output<Either<String, AssessmentSizingCriterion>>) {
        this.sizingCriterion = value
    }

    /**
     * @param value User configurable setting that describes the status of the assessment.
     */
    @JvmName("gnmyhxnfpxywlmeg")
    public suspend fun stage(`value`: Output<Either<String, AssessmentStage>>) {
        this.stage = value
    }

    /**
     * @param value Time range of performance data used to recommend a size.
     */
    @JvmName("bbdmwboffpqmkigy")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value Specify the duration for which the VMs are up in the on-premises environment.
     */
    @JvmName("ybmwxtvbnbxuoalp")
    public suspend fun vmUptime(`value`: Output<VmUptimeArgs>) {
        this.vmUptime = value
    }

    /**
     * @param value Storage type selected for this disk.
     */
    @JvmName("atjihbbpmdclgpho")
    public suspend fun azureDiskType(`value`: Either<String, AzureDiskType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDiskType = mapped
    }

    /**
     * @param value Storage type selected for this disk.
     */
    @JvmName("waqtmjounagwygur")
    public fun azureDiskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDiskType = mapped
    }

    /**
     * @param value Storage type selected for this disk.
     */
    @JvmName("mekrcxdctyfionds")
    public fun azureDiskType(`value`: AzureDiskType) {
        val toBeMapped = Either.ofRight<String, AzureDiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDiskType = mapped
    }

    /**
     * @param value AHUB discount on windows virtual machines.
     */
    @JvmName("jcygntrfxjlympyi")
    public suspend fun azureHybridUseBenefit(`value`: Either<String, AzureHybridUseBenefit>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value AHUB discount on windows virtual machines.
     */
    @JvmName("karrnvkwvxsgygip")
    public fun azureHybridUseBenefit(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value AHUB discount on windows virtual machines.
     */
    @JvmName("kqnusvbclckhyerk")
    public fun azureHybridUseBenefit(`value`: AzureHybridUseBenefit) {
        val toBeMapped = Either.ofRight<String, AzureHybridUseBenefit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureHybridUseBenefit = mapped
    }

    /**
     * @param value Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
     */
    @JvmName("aphmaodgwrglfspw")
    public suspend fun azureLocation(`value`: Either<String, AzureLocation>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
     */
    @JvmName("glicakxceyflqoct")
    public fun azureLocation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Target Azure location for which the machines should be assessed. These enums are the same as used by Compute API.
     */
    @JvmName("osqufnedbtydjvbf")
    public fun azureLocation(`value`: AzureLocation) {
        val toBeMapped = Either.ofRight<String, AzureLocation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureLocation = mapped
    }

    /**
     * @param value Offer code according to which cost estimation is done.
     */
    @JvmName("upyrshajkhmlxsyj")
    public suspend fun azureOfferCode(`value`: Either<String, AzureOfferCode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Offer code according to which cost estimation is done.
     */
    @JvmName("jpmrfkwgxyycphth")
    public fun azureOfferCode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Offer code according to which cost estimation is done.
     */
    @JvmName("lqdpxrcbyigumcvd")
    public fun azureOfferCode(`value`: AzureOfferCode) {
        val toBeMapped = Either.ofRight<String, AzureOfferCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureOfferCode = mapped
    }

    /**
     * @param value Pricing tier for Size evaluation.
     */
    @JvmName("miqqitgdapxdayre")
    public suspend fun azurePricingTier(`value`: Either<String, AzurePricingTier>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Pricing tier for Size evaluation.
     */
    @JvmName("ydpfaqvqhtdcgbsi")
    public fun azurePricingTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzurePricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Pricing tier for Size evaluation.
     */
    @JvmName("wdffhmhnxgudvxbk")
    public fun azurePricingTier(`value`: AzurePricingTier) {
        val toBeMapped = Either.ofRight<String, AzurePricingTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azurePricingTier = mapped
    }

    /**
     * @param value Storage Redundancy type offered by Azure.
     */
    @JvmName("qbgpkuqiwtsbhryp")
    public suspend fun azureStorageRedundancy(`value`: Either<String, AzureStorageRedundancy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value Storage Redundancy type offered by Azure.
     */
    @JvmName("ppjekbdckkgechvo")
    public fun azureStorageRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value Storage Redundancy type offered by Azure.
     */
    @JvmName("tjngxwyswwwomopp")
    public fun azureStorageRedundancy(`value`: AzureStorageRedundancy) {
        val toBeMapped = Either.ofRight<String, AzureStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureStorageRedundancy = mapped
    }

    /**
     * @param value List of azure VM families.
     */
    @JvmName("nflaiffnbdmoeegm")
    public suspend fun azureVmFamilies(`value`: List<Either<String, AzureVmFamily>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureVmFamilies = mapped
    }

    /**
     * @param values List of azure VM families.
     */
    @JvmName("dviyhflwkndvnkui")
    public suspend fun azureVmFamilies(vararg values: Either<String, AzureVmFamily>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureVmFamilies = mapped
    }

    /**
     * @param value Currency to report prices in.
     */
    @JvmName("jreiygmvswfnrryi")
    public suspend fun currency(`value`: Either<String, Currency>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency to report prices in.
     */
    @JvmName("nxceahiqiqpdscts")
    public fun currency(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Currency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Currency to report prices in.
     */
    @JvmName("gwmgiidxtqbbsgqm")
    public fun currency(`value`: Currency) {
        val toBeMapped = Either.ofRight<String, Currency>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
     */
    @JvmName("kgjrimnfvedrdipk")
    public suspend fun discountPercentage(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.discountPercentage = mapped
    }

    /**
     * @param value Percentile of performance data used to recommend Azure size.
     */
    @JvmName("eodwpdnqbykrleci")
    public suspend fun percentile(`value`: Either<String, Percentile>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of performance data used to recommend Azure size.
     */
    @JvmName("mljspbwkoepwbvfw")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Percentile of performance data used to recommend Azure size.
     */
    @JvmName("muhqtxlsonhfmuof")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Azure reserved instance.
     */
    @JvmName("ttmbrckckqtuwqpg")
    public suspend fun reservedInstance(`value`: Either<String, ReservedInstance>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Azure reserved instance.
     */
    @JvmName("qntiemlruagvodaw")
    public fun reservedInstance(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Azure reserved instance.
     */
    @JvmName("itwcchwveeixdfat")
    public fun reservedInstance(`value`: ReservedInstance) {
        val toBeMapped = Either.ofRight<String, ReservedInstance>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedInstance = mapped
    }

    /**
     * @param value Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure. Min Value = 1.0, Max value = 1.9, Default = 1.3.
     */
    @JvmName("lhtngbwlutmusljy")
    public suspend fun scalingFactor(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingFactor = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("ktehrtyacnqkawub")
    public suspend fun sizingCriterion(`value`: Either<String, AssessmentSizingCriterion>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("uhtkewduypsmydtd")
    public fun sizingCriterion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value Assessment sizing criterion.
     */
    @JvmName("fvdedbycifwolqkf")
    public fun sizingCriterion(`value`: AssessmentSizingCriterion) {
        val toBeMapped = Either.ofRight<String, AssessmentSizingCriterion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizingCriterion = mapped
    }

    /**
     * @param value User configurable setting that describes the status of the assessment.
     */
    @JvmName("gqlaxgrmkvcfeopi")
    public suspend fun stage(`value`: Either<String, AssessmentStage>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value User configurable setting that describes the status of the assessment.
     */
    @JvmName("whcwbteciqsbjigv")
    public fun stage(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentStage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value User configurable setting that describes the status of the assessment.
     */
    @JvmName("eurhobcrdmysffuk")
    public fun stage(`value`: AssessmentStage) {
        val toBeMapped = Either.ofRight<String, AssessmentStage>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stage = mapped
    }

    /**
     * @param value Time range of performance data used to recommend a size.
     */
    @JvmName("dafbvwqyayuktsei")
    public suspend fun timeRange(`value`: Either<String, TimeRange>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time range of performance data used to recommend a size.
     */
    @JvmName("ycpafmhtrnlltbfb")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Time range of performance data used to recommend a size.
     */
    @JvmName("aslveethnwlvxptm")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Specify the duration for which the VMs are up in the on-premises environment.
     */
    @JvmName("ipignybrblbbyqpf")
    public suspend fun vmUptime(`value`: VmUptimeArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmUptime = mapped
    }

    /**
     * @param argument Specify the duration for which the VMs are up in the on-premises environment.
     */
    @JvmName("lxotoafqpefophbm")
    public suspend fun vmUptime(argument: suspend VmUptimeArgsBuilder.() -> Unit) {
        val toBeMapped = VmUptimeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmUptime = mapped
    }

    internal fun build(): AssessmentPropertiesArgs = AssessmentPropertiesArgs(
        azureDiskType = azureDiskType ?: throw PulumiNullFieldException("azureDiskType"),
        azureHybridUseBenefit = azureHybridUseBenefit ?: throw
            PulumiNullFieldException("azureHybridUseBenefit"),
        azureLocation = azureLocation ?: throw PulumiNullFieldException("azureLocation"),
        azureOfferCode = azureOfferCode ?: throw PulumiNullFieldException("azureOfferCode"),
        azurePricingTier = azurePricingTier ?: throw PulumiNullFieldException("azurePricingTier"),
        azureStorageRedundancy = azureStorageRedundancy ?: throw
            PulumiNullFieldException("azureStorageRedundancy"),
        azureVmFamilies = azureVmFamilies ?: throw PulumiNullFieldException("azureVmFamilies"),
        currency = currency ?: throw PulumiNullFieldException("currency"),
        discountPercentage = discountPercentage ?: throw PulumiNullFieldException("discountPercentage"),
        percentile = percentile ?: throw PulumiNullFieldException("percentile"),
        reservedInstance = reservedInstance ?: throw PulumiNullFieldException("reservedInstance"),
        scalingFactor = scalingFactor ?: throw PulumiNullFieldException("scalingFactor"),
        sizingCriterion = sizingCriterion ?: throw PulumiNullFieldException("sizingCriterion"),
        stage = stage ?: throw PulumiNullFieldException("stage"),
        timeRange = timeRange ?: throw PulumiNullFieldException("timeRange"),
        vmUptime = vmUptime ?: throw PulumiNullFieldException("vmUptime"),
    )
}
