@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AssessmentScopeParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data model of Assessment Scope Parameters.
 * @property serverGroupId Gets or sets the server group id.
 */
public data class AssessmentScopeParametersArgs(
    public val serverGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AssessmentScopeParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AssessmentScopeParametersArgs =
        com.pulumi.azurenative.migrate.inputs.AssessmentScopeParametersArgs.builder()
            .serverGroupId(serverGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentScopeParametersArgs].
 */
@PulumiTagMarker
public class AssessmentScopeParametersArgsBuilder internal constructor() {
    private var serverGroupId: Output<String>? = null

    /**
     * @param value Gets or sets the server group id.
     */
    @JvmName("iquawakpvbiyyony")
    public suspend fun serverGroupId(`value`: Output<String>) {
        this.serverGroupId = value
    }

    /**
     * @param value Gets or sets the server group id.
     */
    @JvmName("ixxnoaqnlvolbaat")
    public suspend fun serverGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverGroupId = mapped
    }

    internal fun build(): AssessmentScopeParametersArgs = AssessmentScopeParametersArgs(
        serverGroupId = serverGroupId,
    )
}
