@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.AvailabilitySetResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Gets or sets the availability set resource settings.
 * @property faultDomain Gets or sets the target fault domain.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Compute/availabilitySets'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property updateDomain Gets or sets the target update domain.
 */
public data class AvailabilitySetResourceSettingsArgs(
    public val faultDomain: Output<Int>? = null,
    public val resourceType: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
    public val updateDomain: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.AvailabilitySetResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.AvailabilitySetResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.AvailabilitySetResourceSettingsArgs.builder()
            .faultDomain(faultDomain?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 }))
            .updateDomain(updateDomain?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AvailabilitySetResourceSettingsArgs].
 */
@PulumiTagMarker
public class AvailabilitySetResourceSettingsArgsBuilder internal constructor() {
    private var faultDomain: Output<Int>? = null

    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var updateDomain: Output<Int>? = null

    /**
     * @param value Gets or sets the target fault domain.
     */
    @JvmName("cormfduyjxrpomfj")
    public suspend fun faultDomain(`value`: Output<Int>) {
        this.faultDomain = value
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Compute/availabilitySets'.
     */
    @JvmName("jnhehyowqokvsuig")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("jrnwmtfwapcqitlo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("slhyikyoqphyguvt")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("kalsipoylgvrejhf")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets the target update domain.
     */
    @JvmName("ohgaiepbfqimxuxb")
    public suspend fun updateDomain(`value`: Output<Int>) {
        this.updateDomain = value
    }

    /**
     * @param value Gets or sets the target fault domain.
     */
    @JvmName("ochikrecaclraudr")
    public suspend fun faultDomain(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.faultDomain = mapped
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Compute/availabilitySets'.
     */
    @JvmName("trmecooycfrbwbtx")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("usyxchjfmueqqdiv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("lnxiskbecygrqlfq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("qcmqqpyttmttbbxh")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("xuhuvcxvyfgfpkwh")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value Gets or sets the target update domain.
     */
    @JvmName("xrtbrenbmeyfbwtk")
    public suspend fun updateDomain(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateDomain = mapped
    }

    internal fun build(): AvailabilitySetResourceSettingsArgs = AvailabilitySetResourceSettingsArgs(
        faultDomain = faultDomain,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        updateDomain = updateDomain,
    )
}
