@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.DiscoveredEntityLightSummaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Discovered entity light summary.
 * @property numberOfMachines Gets or sets the number of machines.
 * @property numberOfServers Gets or sets the number of servers.
 * @property numberOfWebApps Gets or sets the number of web apps.
 */
public data class DiscoveredEntityLightSummaryArgs(
    public val numberOfMachines: Output<Int>,
    public val numberOfServers: Output<Int>,
    public val numberOfWebApps: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.DiscoveredEntityLightSummaryArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.DiscoveredEntityLightSummaryArgs =
        com.pulumi.azurenative.migrate.inputs.DiscoveredEntityLightSummaryArgs.builder()
            .numberOfMachines(numberOfMachines.applyValue({ args0 -> args0 }))
            .numberOfServers(numberOfServers.applyValue({ args0 -> args0 }))
            .numberOfWebApps(numberOfWebApps.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiscoveredEntityLightSummaryArgs].
 */
@PulumiTagMarker
public class DiscoveredEntityLightSummaryArgsBuilder internal constructor() {
    private var numberOfMachines: Output<Int>? = null

    private var numberOfServers: Output<Int>? = null

    private var numberOfWebApps: Output<Int>? = null

    /**
     * @param value Gets or sets the number of machines.
     */
    @JvmName("waxhdncjiulrrrps")
    public suspend fun numberOfMachines(`value`: Output<Int>) {
        this.numberOfMachines = value
    }

    /**
     * @param value Gets or sets the number of servers.
     */
    @JvmName("vedlvtuqigditvds")
    public suspend fun numberOfServers(`value`: Output<Int>) {
        this.numberOfServers = value
    }

    /**
     * @param value Gets or sets the number of web apps.
     */
    @JvmName("pbcihtqbcuanjutn")
    public suspend fun numberOfWebApps(`value`: Output<Int>) {
        this.numberOfWebApps = value
    }

    /**
     * @param value Gets or sets the number of machines.
     */
    @JvmName("djpriwyckuoukglj")
    public suspend fun numberOfMachines(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfMachines = mapped
    }

    /**
     * @param value Gets or sets the number of servers.
     */
    @JvmName("syncwgvjlhcfepdj")
    public suspend fun numberOfServers(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfServers = mapped
    }

    /**
     * @param value Gets or sets the number of web apps.
     */
    @JvmName("gbxhplcljqverhbu")
    public suspend fun numberOfWebApps(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfWebApps = mapped
    }

    internal fun build(): DiscoveredEntityLightSummaryArgs = DiscoveredEntityLightSummaryArgs(
        numberOfMachines = numberOfMachines ?: throw PulumiNullFieldException("numberOfMachines"),
        numberOfServers = numberOfServers ?: throw PulumiNullFieldException("numberOfServers"),
        numberOfWebApps = numberOfWebApps ?: throw PulumiNullFieldException("numberOfWebApps"),
    )
}
