@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetAssessmentsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property assessmentName Machine Assessment ARM name
 * @property groupName Group ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAssessmentsOperationPlainArgs(
    public val assessmentName: String,
    public val groupName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetAssessmentsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetAssessmentsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetAssessmentsOperationPlainArgs.builder()
            .assessmentName(assessmentName.let({ args0 -> args0 }))
            .groupName(groupName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssessmentsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetAssessmentsOperationPlainArgsBuilder internal constructor() {
    private var assessmentName: String? = null

    private var groupName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Machine Assessment ARM name
     */
    @JvmName("edbmdwwbyiftjfit")
    public suspend fun assessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.assessmentName = mapped
    }

    /**
     * @param value Group ARM name
     */
    @JvmName("qpavpvjcbifcvorl")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ccdqdtxdnjqqxwew")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("umhnnfmvpqdigbec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssessmentsOperationPlainArgs = GetAssessmentsOperationPlainArgs(
        assessmentName = assessmentName ?: throw PulumiNullFieldException("assessmentName"),
        groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
