@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetBusinessCaseOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property businessCaseName Business case ARM name
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetBusinessCaseOperationPlainArgs(
    public val businessCaseName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetBusinessCaseOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetBusinessCaseOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetBusinessCaseOperationPlainArgs.builder()
            .businessCaseName(businessCaseName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBusinessCaseOperationPlainArgs].
 */
@PulumiTagMarker
public class GetBusinessCaseOperationPlainArgsBuilder internal constructor() {
    private var businessCaseName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Business case ARM name
     */
    @JvmName("mqqboxjrhcnhkusm")
    public suspend fun businessCaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.businessCaseName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("kjimrfncacorjrjf")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aeclucsquhrwtbvv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBusinessCaseOperationPlainArgs = GetBusinessCaseOperationPlainArgs(
        businessCaseName = businessCaseName ?: throw PulumiNullFieldException("businessCaseName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
