@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetHyperVCollectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hyperVCollectorName Unique name of a Hyper-V collector within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetHyperVCollectorPlainArgs(
    public val hyperVCollectorName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetHyperVCollectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetHyperVCollectorPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetHyperVCollectorPlainArgs.builder()
            .hyperVCollectorName(hyperVCollectorName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHyperVCollectorPlainArgs].
 */
@PulumiTagMarker
public class GetHyperVCollectorPlainArgsBuilder internal constructor() {
    private var hyperVCollectorName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique name of a Hyper-V collector within a project.
     */
    @JvmName("psfbkuwniwhnmpcj")
    public suspend fun hyperVCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hyperVCollectorName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("llsoghdylfmsprwh")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("gjcccqyffdtfvswk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHyperVCollectorPlainArgs = GetHyperVCollectorPlainArgs(
        hyperVCollectorName = hyperVCollectorName ?: throw PulumiNullFieldException("hyperVCollectorName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
