@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetMoveCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property moveCollectionName The Move Collection Name.
 * @property resourceGroupName The Resource Group Name.
 */
public data class GetMoveCollectionPlainArgs(
    public val moveCollectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetMoveCollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetMoveCollectionPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetMoveCollectionPlainArgs.builder()
            .moveCollectionName(moveCollectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMoveCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetMoveCollectionPlainArgsBuilder internal constructor() {
    private var moveCollectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Move Collection Name.
     */
    @JvmName("svataejyqwiojoyj")
    public suspend fun moveCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.moveCollectionName = mapped
    }

    /**
     * @param value The Resource Group Name.
     */
    @JvmName("dbpsraokrnvrstop")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMoveCollectionPlainArgs = GetMoveCollectionPlainArgs(
        moveCollectionName = moveCollectionName ?: throw PulumiNullFieldException("moveCollectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
