@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName Unique name of a private endpoint connection within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Unique name of a private endpoint connection within a project.
     */
    @JvmName("gnymmwnwvkgeoukc")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("bbxcutlulqorjfku")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("eqrpkswkpkxyparo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
