@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetServerCollectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property serverCollectorName Unique name of a Server collector within a project.
 */
public data class GetServerCollectorPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
    public val serverCollectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetServerCollectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetServerCollectorPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetServerCollectorPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverCollectorName(serverCollectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerCollectorPlainArgs].
 */
@PulumiTagMarker
public class GetServerCollectorPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var serverCollectorName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("xhvvjkjncyqquhpk")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("onqychpeyctigrpx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a Server collector within a project.
     */
    @JvmName("iyhjdmjavcjyjqbi")
    public suspend fun serverCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverCollectorName = mapped
    }

    internal fun build(): GetServerCollectorPlainArgs = GetServerCollectorPlainArgs(
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverCollectorName = serverCollectorName ?: throw PulumiNullFieldException("serverCollectorName"),
    )
}
