@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetVMwareCollectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Name of the Azure Migrate project.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property vmWareCollectorName Unique name of a VMware collector within a project.
 */
public data class GetVMwareCollectorPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
    public val vmWareCollectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetVMwareCollectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetVMwareCollectorPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetVMwareCollectorPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmWareCollectorName(vmWareCollectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVMwareCollectorPlainArgs].
 */
@PulumiTagMarker
public class GetVMwareCollectorPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var vmWareCollectorName: String? = null

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("hjmujyfnidroopxk")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("vptkvkymawjtxwue")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a VMware collector within a project.
     */
    @JvmName("hwafqpstiaieclur")
    public suspend fun vmWareCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmWareCollectorName = mapped
    }

    internal fun build(): GetVMwareCollectorPlainArgs = GetVMwareCollectorPlainArgs(
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmWareCollectorName = vmWareCollectorName ?: throw PulumiNullFieldException("vmWareCollectorName"),
    )
}
