@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GroupPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of group resource.
 * @property groupType The type of group.
 */
public data class GroupPropertiesArgs(
    public val groupType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GroupPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GroupPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.GroupPropertiesArgs.builder()
            .groupType(groupType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupPropertiesArgs].
 */
@PulumiTagMarker
public class GroupPropertiesArgsBuilder internal constructor() {
    private var groupType: Output<String>? = null

    /**
     * @param value The type of group.
     */
    @JvmName("pxyojclfwmgchbgj")
    public suspend fun groupType(`value`: Output<String>) {
        this.groupType = value
    }

    /**
     * @param value The type of group.
     */
    @JvmName("gyqoyymyfaubvgiq")
    public suspend fun groupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupType = mapped
    }

    internal fun build(): GroupPropertiesArgs = GroupPropertiesArgs(
        groupType = groupType,
    )
}
