@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.HypervLicenseArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.HyperVLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Representation of a licence.
 * @property licenseCost Cost of a licence.
 * @property licenseType HyperV licence type.
 */
public data class HypervLicenseArgs(
    public val licenseCost: Output<Double>,
    public val licenseType: Output<Either<String, HyperVLicenseType>>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.HypervLicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.HypervLicenseArgs =
        com.pulumi.azurenative.migrate.inputs.HypervLicenseArgs.builder()
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [HypervLicenseArgs].
 */
@PulumiTagMarker
public class HypervLicenseArgsBuilder internal constructor() {
    private var licenseCost: Output<Double>? = null

    private var licenseType: Output<Either<String, HyperVLicenseType>>? = null

    /**
     * @param value Cost of a licence.
     */
    @JvmName("xfmhbhnpwyaqpyhf")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value HyperV licence type.
     */
    @JvmName("dcbdqgkmgnfghdlv")
    public suspend fun licenseType(`value`: Output<Either<String, HyperVLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Cost of a licence.
     */
    @JvmName("ljmortdcxngakubk")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value HyperV licence type.
     */
    @JvmName("hbnhblyhudlefcsa")
    public suspend fun licenseType(`value`: Either<String, HyperVLicenseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value HyperV licence type.
     */
    @JvmName("okudeddlmrhsmgvl")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value HyperV licence type.
     */
    @JvmName("wcpgwnfluwfhmfme")
    public fun licenseType(`value`: HyperVLicenseType) {
        val toBeMapped = Either.ofRight<String, HyperVLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    internal fun build(): HypervLicenseArgs = HypervLicenseArgs(
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        licenseType = licenseType ?: throw PulumiNullFieldException("licenseType"),
    )
}
