@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ManagementSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Management settings.
 * @property hypervVirtualizationManagementSettings HyperV Virtualization Management Settings.
 * @property otherManagementCostsSettings Other Management Costs Settings.
 * @property thirdPartyManagementSettings Third Party Management Settings.
 * @property vsphereManagementSettings vSphere Management Settings.
 */
public data class ManagementSettingsArgs(
    public val hypervVirtualizationManagementSettings:
    Output<HypervVirtualizationManagementSettingsArgs>,
    public val otherManagementCostsSettings: Output<OtherManagementCostsSettingsArgs>,
    public val thirdPartyManagementSettings: Output<ThirdPartyManagementSettingsArgs>,
    public val vsphereManagementSettings: Output<VsphereManagementSettingsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ManagementSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ManagementSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.ManagementSettingsArgs.builder()
            .hypervVirtualizationManagementSettings(
                hypervVirtualizationManagementSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .otherManagementCostsSettings(
                otherManagementCostsSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .thirdPartyManagementSettings(
                thirdPartyManagementSettings.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .vsphereManagementSettings(
                vsphereManagementSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagementSettingsArgs].
 */
@PulumiTagMarker
public class ManagementSettingsArgsBuilder internal constructor() {
    private var hypervVirtualizationManagementSettings:
        Output<HypervVirtualizationManagementSettingsArgs>? = null

    private var otherManagementCostsSettings: Output<OtherManagementCostsSettingsArgs>? = null

    private var thirdPartyManagementSettings: Output<ThirdPartyManagementSettingsArgs>? = null

    private var vsphereManagementSettings: Output<VsphereManagementSettingsArgs>? = null

    /**
     * @param value HyperV Virtualization Management Settings.
     */
    @JvmName("hoxmjyqryqhbihxi")
    public suspend
    fun hypervVirtualizationManagementSettings(`value`: Output<HypervVirtualizationManagementSettingsArgs>) {
        this.hypervVirtualizationManagementSettings = value
    }

    /**
     * @param value Other Management Costs Settings.
     */
    @JvmName("uokljeauvhqkxqvd")
    public suspend
    fun otherManagementCostsSettings(`value`: Output<OtherManagementCostsSettingsArgs>) {
        this.otherManagementCostsSettings = value
    }

    /**
     * @param value Third Party Management Settings.
     */
    @JvmName("monwhagryqtqlwhk")
    public suspend
    fun thirdPartyManagementSettings(`value`: Output<ThirdPartyManagementSettingsArgs>) {
        this.thirdPartyManagementSettings = value
    }

    /**
     * @param value vSphere Management Settings.
     */
    @JvmName("etvuxsfmkhrebmtb")
    public suspend fun vsphereManagementSettings(`value`: Output<VsphereManagementSettingsArgs>) {
        this.vsphereManagementSettings = value
    }

    /**
     * @param value HyperV Virtualization Management Settings.
     */
    @JvmName("armemymhlsphabbo")
    public suspend
    fun hypervVirtualizationManagementSettings(`value`: HypervVirtualizationManagementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hypervVirtualizationManagementSettings = mapped
    }

    /**
     * @param argument HyperV Virtualization Management Settings.
     */
    @JvmName("asdixycgvywfopay")
    public suspend
    fun hypervVirtualizationManagementSettings(argument: suspend HypervVirtualizationManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = HypervVirtualizationManagementSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.hypervVirtualizationManagementSettings = mapped
    }

    /**
     * @param value Other Management Costs Settings.
     */
    @JvmName("drvmcyrfbrxttyds")
    public suspend fun otherManagementCostsSettings(`value`: OtherManagementCostsSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.otherManagementCostsSettings = mapped
    }

    /**
     * @param argument Other Management Costs Settings.
     */
    @JvmName("xsvojmsvvkiejfcr")
    public suspend
    fun otherManagementCostsSettings(argument: suspend OtherManagementCostsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = OtherManagementCostsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.otherManagementCostsSettings = mapped
    }

    /**
     * @param value Third Party Management Settings.
     */
    @JvmName("bqiayxbehtwhvygm")
    public suspend fun thirdPartyManagementSettings(`value`: ThirdPartyManagementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thirdPartyManagementSettings = mapped
    }

    /**
     * @param argument Third Party Management Settings.
     */
    @JvmName("upxegchxrllocxpr")
    public suspend
    fun thirdPartyManagementSettings(argument: suspend ThirdPartyManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ThirdPartyManagementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.thirdPartyManagementSettings = mapped
    }

    /**
     * @param value vSphere Management Settings.
     */
    @JvmName("qammgcqpejmanojg")
    public suspend fun vsphereManagementSettings(`value`: VsphereManagementSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vsphereManagementSettings = mapped
    }

    /**
     * @param argument vSphere Management Settings.
     */
    @JvmName("uiadxfsrmdastnft")
    public suspend
    fun vsphereManagementSettings(argument: suspend VsphereManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = VsphereManagementSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vsphereManagementSettings = mapped
    }

    internal fun build(): ManagementSettingsArgs = ManagementSettingsArgs(
        hypervVirtualizationManagementSettings = hypervVirtualizationManagementSettings ?: throw
            PulumiNullFieldException("hypervVirtualizationManagementSettings"),
        otherManagementCostsSettings = otherManagementCostsSettings ?: throw
            PulumiNullFieldException("otherManagementCostsSettings"),
        thirdPartyManagementSettings = thirdPartyManagementSettings ?: throw
            PulumiNullFieldException("thirdPartyManagementSettings"),
        vsphereManagementSettings = vsphereManagementSettings ?: throw
            PulumiNullFieldException("vsphereManagementSettings"),
    )
}
