@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MigrateAgentModelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * MigrateAgent model properties.
 * @property authenticationIdentity Identity model.
 * @property customProperties MigrateAgent model custom properties.
 * @property machineId Gets or sets the machine Id where MigrateAgent is running.
 * @property machineName Gets or sets the machine name where MigrateAgent is running.
 */
public data class MigrateAgentModelPropertiesArgs(
    public val authenticationIdentity: Output<IdentityModelArgs>? = null,
    public val customProperties: Output<VMwareMigrateAgentModelCustomPropertiesArgs>? = null,
    public val machineId: Output<String>? = null,
    public val machineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MigrateAgentModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MigrateAgentModelPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.MigrateAgentModelPropertiesArgs.builder()
            .authenticationIdentity(
                authenticationIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customProperties(customProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .machineId(machineId?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateAgentModelPropertiesArgs].
 */
@PulumiTagMarker
public class MigrateAgentModelPropertiesArgsBuilder internal constructor() {
    private var authenticationIdentity: Output<IdentityModelArgs>? = null

    private var customProperties: Output<VMwareMigrateAgentModelCustomPropertiesArgs>? = null

    private var machineId: Output<String>? = null

    private var machineName: Output<String>? = null

    /**
     * @param value Identity model.
     */
    @JvmName("etmqwnwtunsyxvno")
    public suspend fun authenticationIdentity(`value`: Output<IdentityModelArgs>) {
        this.authenticationIdentity = value
    }

    /**
     * @param value MigrateAgent model custom properties.
     */
    @JvmName("smfehnqqxeepltba")
    public suspend
    fun customProperties(`value`: Output<VMwareMigrateAgentModelCustomPropertiesArgs>) {
        this.customProperties = value
    }

    /**
     * @param value Gets or sets the machine Id where MigrateAgent is running.
     */
    @JvmName("kgxgtdggeygkylhv")
    public suspend fun machineId(`value`: Output<String>) {
        this.machineId = value
    }

    /**
     * @param value Gets or sets the machine name where MigrateAgent is running.
     */
    @JvmName("vjicdpgskkbfkvjt")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Identity model.
     */
    @JvmName("xdsvqucdtvmeiaau")
    public suspend fun authenticationIdentity(`value`: IdentityModelArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationIdentity = mapped
    }

    /**
     * @param argument Identity model.
     */
    @JvmName("avajmtkheswsirvm")
    public suspend fun authenticationIdentity(argument: suspend IdentityModelArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityModelArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationIdentity = mapped
    }

    /**
     * @param value MigrateAgent model custom properties.
     */
    @JvmName("jjtaphelvdnlcffm")
    public suspend fun customProperties(`value`: VMwareMigrateAgentModelCustomPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param argument MigrateAgent model custom properties.
     */
    @JvmName("wwroealnxlajsmvb")
    public suspend
    fun customProperties(argument: suspend VMwareMigrateAgentModelCustomPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMwareMigrateAgentModelCustomPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customProperties = mapped
    }

    /**
     * @param value Gets or sets the machine Id where MigrateAgent is running.
     */
    @JvmName("unfkfmfavqhhccwd")
    public suspend fun machineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineId = mapped
    }

    /**
     * @param value Gets or sets the machine name where MigrateAgent is running.
     */
    @JvmName("vdhghecbfrjcdhoy")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    internal fun build(): MigrateAgentModelPropertiesArgs = MigrateAgentModelPropertiesArgs(
        authenticationIdentity = authenticationIdentity,
        customProperties = customProperties,
        machineId = machineId,
        machineName = machineName,
    )
}
