@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MoveResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the move resource properties.
 * @property dependsOnOverrides Gets or sets the move resource dependencies overrides.
 * @property existingTargetId Gets or sets the existing target ARM Id of the resource.
 * @property resourceSettings Gets or sets the resource settings.
 * @property sourceId Gets or sets the Source ARM Id of the resource.
 */
public data class MoveResourcePropertiesArgs(
    public val dependsOnOverrides: Output<List<MoveResourceDependencyOverrideArgs>>? = null,
    public val existingTargetId: Output<String>? = null,
    public val resourceSettings: Output<Any>? = null,
    public val sourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MoveResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MoveResourcePropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.MoveResourcePropertiesArgs.builder()
            .dependsOnOverrides(
                dependsOnOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .existingTargetId(existingTargetId?.applyValue({ args0 -> args0 }))
            .resourceSettings(resourceSettings?.applyValue({ args0 -> args0 }))
            .sourceId(sourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MoveResourcePropertiesArgs].
 */
@PulumiTagMarker
public class MoveResourcePropertiesArgsBuilder internal constructor() {
    private var dependsOnOverrides: Output<List<MoveResourceDependencyOverrideArgs>>? = null

    private var existingTargetId: Output<String>? = null

    private var resourceSettings: Output<Any>? = null

    private var sourceId: Output<String>? = null

    /**
     * @param value Gets or sets the move resource dependencies overrides.
     */
    @JvmName("bwyylgpfdinsdobc")
    public suspend fun dependsOnOverrides(`value`: Output<List<MoveResourceDependencyOverrideArgs>>) {
        this.dependsOnOverrides = value
    }

    @JvmName("xgbpfqrnexvynmpq")
    public suspend fun dependsOnOverrides(vararg values: Output<MoveResourceDependencyOverrideArgs>) {
        this.dependsOnOverrides = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the move resource dependencies overrides.
     */
    @JvmName("skpheyeewnthfkya")
    public suspend fun dependsOnOverrides(values: List<Output<MoveResourceDependencyOverrideArgs>>) {
        this.dependsOnOverrides = Output.all(values)
    }

    /**
     * @param value Gets or sets the existing target ARM Id of the resource.
     */
    @JvmName("hhlaoujkbqpchcka")
    public suspend fun existingTargetId(`value`: Output<String>) {
        this.existingTargetId = value
    }

    /**
     * @param value Gets or sets the resource settings.
     */
    @JvmName("nglcptxafgdlfwbe")
    public suspend fun resourceSettings(`value`: Output<Any>) {
        this.resourceSettings = value
    }

    /**
     * @param value Gets or sets the Source ARM Id of the resource.
     */
    @JvmName("rbxvsjxckrqexjsv")
    public suspend fun sourceId(`value`: Output<String>) {
        this.sourceId = value
    }

    /**
     * @param value Gets or sets the move resource dependencies overrides.
     */
    @JvmName("hjnlmsxrcvhlrhml")
    public suspend fun dependsOnOverrides(`value`: List<MoveResourceDependencyOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOnOverrides = mapped
    }

    /**
     * @param argument Gets or sets the move resource dependencies overrides.
     */
    @JvmName("bjlwdcaoutheppal")
    public suspend
    fun dependsOnOverrides(argument: List<suspend MoveResourceDependencyOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MoveResourceDependencyOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOnOverrides = mapped
    }

    /**
     * @param argument Gets or sets the move resource dependencies overrides.
     */
    @JvmName("bxhjvjonfpctihkw")
    public suspend fun dependsOnOverrides(
        vararg
        argument: suspend MoveResourceDependencyOverrideArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MoveResourceDependencyOverrideArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOnOverrides = mapped
    }

    /**
     * @param argument Gets or sets the move resource dependencies overrides.
     */
    @JvmName("licraoqqkmgsoivr")
    public suspend
    fun dependsOnOverrides(argument: suspend MoveResourceDependencyOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MoveResourceDependencyOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dependsOnOverrides = mapped
    }

    /**
     * @param values Gets or sets the move resource dependencies overrides.
     */
    @JvmName("nmqlxfyosdavmxct")
    public suspend fun dependsOnOverrides(vararg values: MoveResourceDependencyOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOnOverrides = mapped
    }

    /**
     * @param value Gets or sets the existing target ARM Id of the resource.
     */
    @JvmName("nssdlsjavfckwllu")
    public suspend fun existingTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.existingTargetId = mapped
    }

    /**
     * @param value Gets or sets the resource settings.
     */
    @JvmName("uvailxjqlobvcfxc")
    public suspend fun resourceSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSettings = mapped
    }

    /**
     * @param value Gets or sets the Source ARM Id of the resource.
     */
    @JvmName("kkycjffpcebufola")
    public suspend fun sourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceId = mapped
    }

    internal fun build(): MoveResourcePropertiesArgs = MoveResourcePropertiesArgs(
        dependsOnOverrides = dependsOnOverrides,
        existingTargetId = existingTargetId,
        resourceSettings = resourceSettings,
        sourceId = sourceId ?: throw PulumiNullFieldException("sourceId"),
    )
}
