@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.NicIpConfigurationResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines NIC IP configuration properties.
 * @property loadBalancerBackendAddressPools Gets or sets the references of the load balancer backend address pools.
 * @property loadBalancerNatRules Gets or sets the references of the load balancer NAT rules.
 * @property name Gets or sets the IP configuration name.
 * @property primary Gets or sets a value indicating whether this IP configuration is the primary.
 * @property privateIpAddress Gets or sets the private IP address of the network interface IP Configuration.
 * @property privateIpAllocationMethod Gets or sets the private IP address allocation method.
 * @property publicIp Defines reference to a public IP.
 * @property subnet Defines reference to subnet.
 */
public data class NicIpConfigurationResourceSettingsArgs(
    public val loadBalancerBackendAddressPools:
    Output<List<LoadBalancerBackendAddressPoolReferenceArgs>>? = null,
    public val loadBalancerNatRules: Output<List<LoadBalancerNatRuleReferenceArgs>>? = null,
    public val name: Output<String>? = null,
    public val primary: Output<Boolean>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val privateIpAllocationMethod: Output<String>? = null,
    public val publicIp: Output<PublicIpReferenceArgs>? = null,
    public val subnet: Output<SubnetReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.NicIpConfigurationResourceSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.NicIpConfigurationResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.NicIpConfigurationResourceSettingsArgs.builder()
            .loadBalancerBackendAddressPools(
                loadBalancerBackendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .loadBalancerNatRules(
                loadBalancerNatRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .primary(primary?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .privateIpAllocationMethod(privateIpAllocationMethod?.applyValue({ args0 -> args0 }))
            .publicIp(publicIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NicIpConfigurationResourceSettingsArgs].
 */
@PulumiTagMarker
public class NicIpConfigurationResourceSettingsArgsBuilder internal constructor() {
    private var loadBalancerBackendAddressPools:
        Output<List<LoadBalancerBackendAddressPoolReferenceArgs>>? = null

    private var loadBalancerNatRules: Output<List<LoadBalancerNatRuleReferenceArgs>>? = null

    private var name: Output<String>? = null

    private var primary: Output<Boolean>? = null

    private var privateIpAddress: Output<String>? = null

    private var privateIpAllocationMethod: Output<String>? = null

    private var publicIp: Output<PublicIpReferenceArgs>? = null

    private var subnet: Output<SubnetReferenceArgs>? = null

    /**
     * @param value Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("wamcyucwpcskqntq")
    public suspend
    fun loadBalancerBackendAddressPools(`value`: Output<List<LoadBalancerBackendAddressPoolReferenceArgs>>) {
        this.loadBalancerBackendAddressPools = value
    }

    @JvmName("jvyjdxddhlcrobux")
    public suspend fun loadBalancerBackendAddressPools(
        vararg
        values: Output<LoadBalancerBackendAddressPoolReferenceArgs>,
    ) {
        this.loadBalancerBackendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("lodhhudynmkapwdl")
    public suspend
    fun loadBalancerBackendAddressPools(values: List<Output<LoadBalancerBackendAddressPoolReferenceArgs>>) {
        this.loadBalancerBackendAddressPools = Output.all(values)
    }

    /**
     * @param value Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("fclurjjvylbxrvoe")
    public suspend fun loadBalancerNatRules(`value`: Output<List<LoadBalancerNatRuleReferenceArgs>>) {
        this.loadBalancerNatRules = value
    }

    @JvmName("pramrhvdmxkwrghk")
    public suspend fun loadBalancerNatRules(vararg values: Output<LoadBalancerNatRuleReferenceArgs>) {
        this.loadBalancerNatRules = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("ntplwqdxrmtrigem")
    public suspend fun loadBalancerNatRules(values: List<Output<LoadBalancerNatRuleReferenceArgs>>) {
        this.loadBalancerNatRules = Output.all(values)
    }

    /**
     * @param value Gets or sets the IP configuration name.
     */
    @JvmName("hlursqpnrxeugcni")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets a value indicating whether this IP configuration is the primary.
     */
    @JvmName("vgujdbvpafpgkebc")
    public suspend fun primary(`value`: Output<Boolean>) {
        this.primary = value
    }

    /**
     * @param value Gets or sets the private IP address of the network interface IP Configuration.
     */
    @JvmName("qmhbbfakmiiqhmtd")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Gets or sets the private IP address allocation method.
     */
    @JvmName("uallhxyrlqktpetq")
    public suspend fun privateIpAllocationMethod(`value`: Output<String>) {
        this.privateIpAllocationMethod = value
    }

    /**
     * @param value Defines reference to a public IP.
     */
    @JvmName("svtexgpqtsscaovs")
    public suspend fun publicIp(`value`: Output<PublicIpReferenceArgs>) {
        this.publicIp = value
    }

    /**
     * @param value Defines reference to subnet.
     */
    @JvmName("matwrifjjlfgljuw")
    public suspend fun subnet(`value`: Output<SubnetReferenceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("qjaddqvsjjdrljsu")
    public suspend
    fun loadBalancerBackendAddressPools(`value`: List<LoadBalancerBackendAddressPoolReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("egdkhrfmddfodnbp")
    public suspend
    fun loadBalancerBackendAddressPools(argument: List<suspend LoadBalancerBackendAddressPoolReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressPoolReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("bkpyygarrqdardnt")
    public suspend fun loadBalancerBackendAddressPools(
        vararg
        argument: suspend LoadBalancerBackendAddressPoolReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerBackendAddressPoolReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("xqnwclkuuirlxivi")
    public suspend
    fun loadBalancerBackendAddressPools(argument: suspend LoadBalancerBackendAddressPoolReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerBackendAddressPoolReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param values Gets or sets the references of the load balancer backend address pools.
     */
    @JvmName("lssmkbtinpvmmhfv")
    public suspend fun loadBalancerBackendAddressPools(
        vararg
        values: LoadBalancerBackendAddressPoolReferenceArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerBackendAddressPools = mapped
    }

    /**
     * @param value Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("xeyrbevhxchcbodv")
    public suspend fun loadBalancerNatRules(`value`: List<LoadBalancerNatRuleReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancerNatRules = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("xwsnqxvociwgbngc")
    public suspend
    fun loadBalancerNatRules(argument: List<suspend LoadBalancerNatRuleReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerNatRuleReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerNatRules = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("rhtniwbufaajjhaj")
    public suspend fun loadBalancerNatRules(
        vararg
        argument: suspend LoadBalancerNatRuleReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LoadBalancerNatRuleReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.loadBalancerNatRules = mapped
    }

    /**
     * @param argument Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("mrplsqnyinfcvaoo")
    public suspend
    fun loadBalancerNatRules(argument: suspend LoadBalancerNatRuleReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LoadBalancerNatRuleReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.loadBalancerNatRules = mapped
    }

    /**
     * @param values Gets or sets the references of the load balancer NAT rules.
     */
    @JvmName("ysqesiyifueiafbb")
    public suspend fun loadBalancerNatRules(vararg values: LoadBalancerNatRuleReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loadBalancerNatRules = mapped
    }

    /**
     * @param value Gets or sets the IP configuration name.
     */
    @JvmName("yqcvmutqdljnayma")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether this IP configuration is the primary.
     */
    @JvmName("tvlksujvxhphgvgy")
    public suspend fun primary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primary = mapped
    }

    /**
     * @param value Gets or sets the private IP address of the network interface IP Configuration.
     */
    @JvmName("awwdvhrcnwlhdjiv")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value Gets or sets the private IP address allocation method.
     */
    @JvmName("lfgykbjmtigupcka")
    public suspend fun privateIpAllocationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAllocationMethod = mapped
    }

    /**
     * @param value Defines reference to a public IP.
     */
    @JvmName("ievwfrjulytpyibb")
    public suspend fun publicIp(`value`: PublicIpReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIp = mapped
    }

    /**
     * @param argument Defines reference to a public IP.
     */
    @JvmName("poifhnsosisgukrj")
    public suspend fun publicIp(argument: suspend PublicIpReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = PublicIpReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicIp = mapped
    }

    /**
     * @param value Defines reference to subnet.
     */
    @JvmName("ywxatixejlwjywae")
    public suspend fun subnet(`value`: SubnetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Defines reference to subnet.
     */
    @JvmName("coohmoobpprvxutm")
    public suspend fun subnet(argument: suspend SubnetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): NicIpConfigurationResourceSettingsArgs =
        NicIpConfigurationResourceSettingsArgs(
            loadBalancerBackendAddressPools = loadBalancerBackendAddressPools,
            loadBalancerNatRules = loadBalancerNatRules,
            name = name,
            primary = primary,
            privateIpAddress = privateIpAddress,
            privateIpAllocationMethod = privateIpAllocationMethod,
            publicIp = publicIp,
            subnet = subnet,
        )
}
