@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.OperatingSystemDetailsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.OperatingSystemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property os
 * @property osArchitecture
 * @property osName
 * @property osVersion
 */
public data class OperatingSystemDetailsArgs(
    public val os: Output<Either<String, OperatingSystemType>>? = null,
    public val osArchitecture: Output<String>? = null,
    public val osName: Output<String>? = null,
    public val osVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.OperatingSystemDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.OperatingSystemDetailsArgs =
        com.pulumi.azurenative.migrate.inputs.OperatingSystemDetailsArgs.builder()
            .os(
                os?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osArchitecture(osArchitecture?.applyValue({ args0 -> args0 }))
            .osName(osName?.applyValue({ args0 -> args0 }))
            .osVersion(osVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OperatingSystemDetailsArgs].
 */
@PulumiTagMarker
public class OperatingSystemDetailsArgsBuilder internal constructor() {
    private var os: Output<Either<String, OperatingSystemType>>? = null

    private var osArchitecture: Output<String>? = null

    private var osName: Output<String>? = null

    private var osVersion: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("psahhgxsjitmrgvq")
    public suspend fun os(`value`: Output<Either<String, OperatingSystemType>>) {
        this.os = value
    }

    /**
     * @param value
     */
    @JvmName("abhmilieodyirptn")
    public suspend fun osArchitecture(`value`: Output<String>) {
        this.osArchitecture = value
    }

    /**
     * @param value
     */
    @JvmName("cdonhwasfdmuukmx")
    public suspend fun osName(`value`: Output<String>) {
        this.osName = value
    }

    /**
     * @param value
     */
    @JvmName("wshnfumquqwkahjw")
    public suspend fun osVersion(`value`: Output<String>) {
        this.osVersion = value
    }

    /**
     * @param value
     */
    @JvmName("ugcnaunjamecelbi")
    public suspend fun os(`value`: Either<String, OperatingSystemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value
     */
    @JvmName("xplabftlvigtxobv")
    public fun os(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value
     */
    @JvmName("kbwekowxbextrpfe")
    public fun os(`value`: OperatingSystemType) {
        val toBeMapped = Either.ofRight<String, OperatingSystemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.os = mapped
    }

    /**
     * @param value
     */
    @JvmName("gnvwfobuximppcyu")
    public suspend fun osArchitecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osArchitecture = mapped
    }

    /**
     * @param value
     */
    @JvmName("kkhrfowuvcwyceet")
    public suspend fun osName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ftigqwtbeiluwwrk")
    public suspend fun osVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osVersion = mapped
    }

    internal fun build(): OperatingSystemDetailsArgs = OperatingSystemDetailsArgs(
        os = os,
        osArchitecture = osArchitecture,
        osName = osName,
        osVersion = osVersion,
    )
}
