@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.PerfDataSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.Percentile
import com.pulumi.azurenative.migrate.kotlin.enums.TimeRange
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Data model of Performance Data Settings.
 * @property percentile Gets percentile utilization for performance data.
 * @property perfDataEndTime Gets or sets perf data end time.
 * @property perfDataStartTime Gets or sets perf data start time.
 * @property timeRange Gets perf data time range.
 */
public data class PerfDataSettingsArgs(
    public val percentile: Output<Either<String, Percentile>>,
    public val perfDataEndTime: Output<String>? = null,
    public val perfDataStartTime: Output<String>? = null,
    public val timeRange: Output<Either<String, TimeRange>>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.PerfDataSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.PerfDataSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.PerfDataSettingsArgs.builder()
            .percentile(
                percentile.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .perfDataEndTime(perfDataEndTime?.applyValue({ args0 -> args0 }))
            .perfDataStartTime(perfDataStartTime?.applyValue({ args0 -> args0 }))
            .timeRange(
                timeRange.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PerfDataSettingsArgs].
 */
@PulumiTagMarker
public class PerfDataSettingsArgsBuilder internal constructor() {
    private var percentile: Output<Either<String, Percentile>>? = null

    private var perfDataEndTime: Output<String>? = null

    private var perfDataStartTime: Output<String>? = null

    private var timeRange: Output<Either<String, TimeRange>>? = null

    /**
     * @param value Gets percentile utilization for performance data.
     */
    @JvmName("ngdkqdbeebfearwp")
    public suspend fun percentile(`value`: Output<Either<String, Percentile>>) {
        this.percentile = value
    }

    /**
     * @param value Gets or sets perf data end time.
     */
    @JvmName("yybykvilxahexhmo")
    public suspend fun perfDataEndTime(`value`: Output<String>) {
        this.perfDataEndTime = value
    }

    /**
     * @param value Gets or sets perf data start time.
     */
    @JvmName("oagcytwndvuxmxot")
    public suspend fun perfDataStartTime(`value`: Output<String>) {
        this.perfDataStartTime = value
    }

    /**
     * @param value Gets perf data time range.
     */
    @JvmName("vwmqhskiasggfsli")
    public suspend fun timeRange(`value`: Output<Either<String, TimeRange>>) {
        this.timeRange = value
    }

    /**
     * @param value Gets percentile utilization for performance data.
     */
    @JvmName("cjavntlbawyybfsi")
    public suspend fun percentile(`value`: Either<String, Percentile>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets percentile utilization for performance data.
     */
    @JvmName("icuyhktcqnbucjtp")
    public fun percentile(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets percentile utilization for performance data.
     */
    @JvmName("waqxclailyqkkfme")
    public fun percentile(`value`: Percentile) {
        val toBeMapped = Either.ofRight<String, Percentile>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.percentile = mapped
    }

    /**
     * @param value Gets or sets perf data end time.
     */
    @JvmName("gqkplcqctwsoslje")
    public suspend fun perfDataEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataEndTime = mapped
    }

    /**
     * @param value Gets or sets perf data start time.
     */
    @JvmName("buahwhampykgedbs")
    public suspend fun perfDataStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.perfDataStartTime = mapped
    }

    /**
     * @param value Gets perf data time range.
     */
    @JvmName("meubutbfvkrjjokv")
    public suspend fun timeRange(`value`: Either<String, TimeRange>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Gets perf data time range.
     */
    @JvmName("dyxflhhrgdmpnodf")
    public fun timeRange(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    /**
     * @param value Gets perf data time range.
     */
    @JvmName("tbomahveronadgqi")
    public fun timeRange(`value`: TimeRange) {
        val toBeMapped = Either.ofRight<String, TimeRange>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeRange = mapped
    }

    internal fun build(): PerfDataSettingsArgs = PerfDataSettingsArgs(
        percentile = percentile ?: throw PulumiNullFieldException("percentile"),
        perfDataEndTime = perfDataEndTime,
        perfDataStartTime = perfDataStartTime,
        timeRange = timeRange ?: throw PulumiNullFieldException("timeRange"),
    )
}
