@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ProjectPropertiesArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProjectStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a project.
 * @property assessmentSolutionId Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
 * @property customerStorageAccountArmId The ARM id of the storage account used for interactions when public access is disabled.
 * @property customerWorkspaceId The ARM id of service map workspace created by customer.
 * @property customerWorkspaceLocation Location of service map workspace created by customer.
 * @property projectStatus Assessment project status.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
 */
public data class ProjectPropertiesArgs(
    public val assessmentSolutionId: Output<String>? = null,
    public val customerStorageAccountArmId: Output<String>? = null,
    public val customerWorkspaceId: Output<String>? = null,
    public val customerWorkspaceLocation: Output<String>? = null,
    public val projectStatus: Output<Either<String, ProjectStatus>>? = null,
    public val publicNetworkAccess: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ProjectPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ProjectPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.ProjectPropertiesArgs.builder()
            .assessmentSolutionId(assessmentSolutionId?.applyValue({ args0 -> args0 }))
            .customerStorageAccountArmId(customerStorageAccountArmId?.applyValue({ args0 -> args0 }))
            .customerWorkspaceId(customerWorkspaceId?.applyValue({ args0 -> args0 }))
            .customerWorkspaceLocation(customerWorkspaceLocation?.applyValue({ args0 -> args0 }))
            .projectStatus(
                projectStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectPropertiesArgs].
 */
@PulumiTagMarker
public class ProjectPropertiesArgsBuilder internal constructor() {
    private var assessmentSolutionId: Output<String>? = null

    private var customerStorageAccountArmId: Output<String>? = null

    private var customerWorkspaceId: Output<String>? = null

    private var customerWorkspaceLocation: Output<String>? = null

    private var projectStatus: Output<Either<String, ProjectStatus>>? = null

    private var publicNetworkAccess: Output<String>? = null

    /**
     * @param value Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
     */
    @JvmName("qesvlobkixnndcun")
    public suspend fun assessmentSolutionId(`value`: Output<String>) {
        this.assessmentSolutionId = value
    }

    /**
     * @param value The ARM id of the storage account used for interactions when public access is disabled.
     */
    @JvmName("shqcxkaxvwxwqcxa")
    public suspend fun customerStorageAccountArmId(`value`: Output<String>) {
        this.customerStorageAccountArmId = value
    }

    /**
     * @param value The ARM id of service map workspace created by customer.
     */
    @JvmName("usvishcleomeotju")
    public suspend fun customerWorkspaceId(`value`: Output<String>) {
        this.customerWorkspaceId = value
    }

    /**
     * @param value Location of service map workspace created by customer.
     */
    @JvmName("oldicdnkjbduhnst")
    public suspend fun customerWorkspaceLocation(`value`: Output<String>) {
        this.customerWorkspaceLocation = value
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("vrofhefovbqoicvy")
    public suspend fun projectStatus(`value`: Output<Either<String, ProjectStatus>>) {
        this.projectStatus = value
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("xplojxaltmqxdqli")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
     */
    @JvmName("wlppdkxhqvkmrvbd")
    public suspend fun assessmentSolutionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentSolutionId = mapped
    }

    /**
     * @param value The ARM id of the storage account used for interactions when public access is disabled.
     */
    @JvmName("okyyftnrkdugeaym")
    public suspend fun customerStorageAccountArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerStorageAccountArmId = mapped
    }

    /**
     * @param value The ARM id of service map workspace created by customer.
     */
    @JvmName("jycxyxmiruvhgnqp")
    public suspend fun customerWorkspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerWorkspaceId = mapped
    }

    /**
     * @param value Location of service map workspace created by customer.
     */
    @JvmName("pcavpyhrqyameomo")
    public suspend fun customerWorkspaceLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerWorkspaceLocation = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("shlcjjecbfonpcus")
    public suspend fun projectStatus(`value`: Either<String, ProjectStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("usysjjjconydpsrr")
    public fun projectStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProjectStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value Assessment project status.
     */
    @JvmName("ilkyewbnycxmejga")
    public fun projectStatus(`value`: ProjectStatus) {
        val toBeMapped = Either.ofRight<String, ProjectStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectStatus = mapped
    }

    /**
     * @param value This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
     */
    @JvmName("txsjyfhmtydsyhwp")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): ProjectPropertiesArgs = ProjectPropertiesArgs(
        assessmentSolutionId = assessmentSolutionId,
        customerStorageAccountArmId = customerStorageAccountArmId,
        customerWorkspaceId = customerWorkspaceId,
        customerWorkspaceLocation = customerWorkspaceLocation,
        projectStatus = projectStatus,
        publicNetworkAccess = publicNetworkAccess,
    )
}
