@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ResourceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource Requirements.
 * @property cpu Gets or sets the Cpu requirement.
 * @property memory Gets or sets the Memory requirement.
 */
public data class ResourceRequirementsArgs(
    public val cpu: Output<String>? = null,
    public val memory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ResourceRequirementsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ResourceRequirementsArgs =
        com.pulumi.azurenative.migrate.inputs.ResourceRequirementsArgs.builder()
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .memory(memory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceRequirementsArgs].
 */
@PulumiTagMarker
public class ResourceRequirementsArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value Gets or sets the Cpu requirement.
     */
    @JvmName("jiwtirqfabowfkeo")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value Gets or sets the Memory requirement.
     */
    @JvmName("aiqbxyjcmbvhvjty")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value Gets or sets the Cpu requirement.
     */
    @JvmName("ymcgbykumsbfsqfv")
    public suspend fun cpu(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value Gets or sets the Memory requirement.
     */
    @JvmName("oakvdssylyglnjja")
    public suspend fun memory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ResourceRequirementsArgs = ResourceRequirementsArgs(
        cpu = cpu,
        memory = memory,
    )
}
