@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SecretStoreDetailsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.SecretStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property secretStore
 * @property secretStoreProperties
 */
public data class SecretStoreDetailsArgs(
    public val secretStore: Output<Either<String, SecretStoreType>>? = null,
    public val secretStoreProperties: Output<SecretStorePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SecretStoreDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SecretStoreDetailsArgs =
        com.pulumi.azurenative.migrate.inputs.SecretStoreDetailsArgs.builder()
            .secretStore(
                secretStore?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secretStoreProperties(
                secretStoreProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SecretStoreDetailsArgs].
 */
@PulumiTagMarker
public class SecretStoreDetailsArgsBuilder internal constructor() {
    private var secretStore: Output<Either<String, SecretStoreType>>? = null

    private var secretStoreProperties: Output<SecretStorePropertiesArgs>? = null

    /**
     * @param value
     */
    @JvmName("qujsrurjoaadmwvp")
    public suspend fun secretStore(`value`: Output<Either<String, SecretStoreType>>) {
        this.secretStore = value
    }

    /**
     * @param value
     */
    @JvmName("xlyemtykvsafgokp")
    public suspend fun secretStoreProperties(`value`: Output<SecretStorePropertiesArgs>) {
        this.secretStoreProperties = value
    }

    /**
     * @param value
     */
    @JvmName("oqdpaekksgydcmlf")
    public suspend fun secretStore(`value`: Either<String, SecretStoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("oisefjxptrwyaquq")
    public fun secretStore(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("uofwlognmegatbgp")
    public fun secretStore(`value`: SecretStoreType) {
        val toBeMapped = Either.ofRight<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param value
     */
    @JvmName("qjccicgufepahvkc")
    public suspend fun secretStoreProperties(`value`: SecretStorePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bbndjgtqxfdppiit")
    public suspend
    fun secretStoreProperties(argument: suspend SecretStorePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SecretStorePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.secretStoreProperties = mapped
    }

    internal fun build(): SecretStoreDetailsArgs = SecretStoreDetailsArgs(
        secretStore = secretStore,
        secretStoreProperties = secretStoreProperties,
    )
}
