@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SecuritySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security settings.
 * @property serverSecurityCostPerServerPerYear Physical servers per administrator.
 * @property sqlServerSecurityCostPerServerPerYear Virtual machines per administrator.
 */
public data class SecuritySettingsArgs(
    public val serverSecurityCostPerServerPerYear: Output<Double>,
    public val sqlServerSecurityCostPerServerPerYear: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SecuritySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SecuritySettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SecuritySettingsArgs.builder()
            .serverSecurityCostPerServerPerYear(
                serverSecurityCostPerServerPerYear.applyValue({ args0 ->
                    args0
                }),
            )
            .sqlServerSecurityCostPerServerPerYear(
                sqlServerSecurityCostPerServerPerYear.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [SecuritySettingsArgs].
 */
@PulumiTagMarker
public class SecuritySettingsArgsBuilder internal constructor() {
    private var serverSecurityCostPerServerPerYear: Output<Double>? = null

    private var sqlServerSecurityCostPerServerPerYear: Output<Double>? = null

    /**
     * @param value Physical servers per administrator.
     */
    @JvmName("ysnpawxkwfosyxqp")
    public suspend fun serverSecurityCostPerServerPerYear(`value`: Output<Double>) {
        this.serverSecurityCostPerServerPerYear = value
    }

    /**
     * @param value Virtual machines per administrator.
     */
    @JvmName("gnisncojbhuxaarh")
    public suspend fun sqlServerSecurityCostPerServerPerYear(`value`: Output<Double>) {
        this.sqlServerSecurityCostPerServerPerYear = value
    }

    /**
     * @param value Physical servers per administrator.
     */
    @JvmName("nocnxqtrdtnwgyxk")
    public suspend fun serverSecurityCostPerServerPerYear(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverSecurityCostPerServerPerYear = mapped
    }

    /**
     * @param value Virtual machines per administrator.
     */
    @JvmName("dugtwqukxydymewb")
    public suspend fun sqlServerSecurityCostPerServerPerYear(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerSecurityCostPerServerPerYear = mapped
    }

    internal fun build(): SecuritySettingsArgs = SecuritySettingsArgs(
        serverSecurityCostPerServerPerYear = serverSecurityCostPerServerPerYear ?: throw
            PulumiNullFieldException("serverSecurityCostPerServerPerYear"),
        sqlServerSecurityCostPerServerPerYear = sqlServerSecurityCostPerServerPerYear ?: throw
            PulumiNullFieldException("sqlServerSecurityCostPerServerPerYear"),
    )
}
