@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SqlServerLicensingSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.SqlServerLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SQL Server licensing settings.
 * @property licenseCost Licence cost.
 * @property softwareAssuranceCost Software assurance (SA) cost.
 * @property version SQL Server version.
 */
public data class SqlServerLicensingSettingsArgs(
    public val licenseCost: Output<Double>,
    public val softwareAssuranceCost: Output<Double>,
    public val version: Output<Either<String, SqlServerLicenseType>>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SqlServerLicensingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SqlServerLicensingSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SqlServerLicensingSettingsArgs.builder()
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .softwareAssuranceCost(softwareAssuranceCost.applyValue({ args0 -> args0 }))
            .version(
                version.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlServerLicensingSettingsArgs].
 */
@PulumiTagMarker
public class SqlServerLicensingSettingsArgsBuilder internal constructor() {
    private var licenseCost: Output<Double>? = null

    private var softwareAssuranceCost: Output<Double>? = null

    private var version: Output<Either<String, SqlServerLicenseType>>? = null

    /**
     * @param value Licence cost.
     */
    @JvmName("qqeqybduigrewaht")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value Software assurance (SA) cost.
     */
    @JvmName("vybescwialvmuyjf")
    public suspend fun softwareAssuranceCost(`value`: Output<Double>) {
        this.softwareAssuranceCost = value
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("pjninapphenmhtsl")
    public suspend fun version(`value`: Output<Either<String, SqlServerLicenseType>>) {
        this.version = value
    }

    /**
     * @param value Licence cost.
     */
    @JvmName("eyfgsetdbdbliloq")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value Software assurance (SA) cost.
     */
    @JvmName("wqcybsypknjnvgyg")
    public suspend fun softwareAssuranceCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceCost = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("njdcxljhdwvrpeku")
    public suspend fun version(`value`: Either<String, SqlServerLicenseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("ynwegqketylndcqy")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("moxvmytjkhtsoiwi")
    public fun version(`value`: SqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SqlServerLicensingSettingsArgs = SqlServerLicensingSettingsArgs(
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        softwareAssuranceCost = softwareAssuranceCost ?: throw
            PulumiNullFieldException("softwareAssuranceCost"),
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
