@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.StorageSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage settings.
 * @property costPerGbPerMonth Cost per gigabyte per month.
 * @property maintainanceCostPercentageToAcquisitionCost Maintenance cost percentage.
 */
public data class StorageSettingsArgs(
    public val costPerGbPerMonth: Output<Double>,
    public val maintainanceCostPercentageToAcquisitionCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.StorageSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.StorageSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.StorageSettingsArgs.builder()
            .costPerGbPerMonth(costPerGbPerMonth.applyValue({ args0 -> args0 }))
            .maintainanceCostPercentageToAcquisitionCost(
                maintainanceCostPercentageToAcquisitionCost.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [StorageSettingsArgs].
 */
@PulumiTagMarker
public class StorageSettingsArgsBuilder internal constructor() {
    private var costPerGbPerMonth: Output<Double>? = null

    private var maintainanceCostPercentageToAcquisitionCost: Output<Double>? = null

    /**
     * @param value Cost per gigabyte per month.
     */
    @JvmName("cqxmwmyuophvmiwx")
    public suspend fun costPerGbPerMonth(`value`: Output<Double>) {
        this.costPerGbPerMonth = value
    }

    /**
     * @param value Maintenance cost percentage.
     */
    @JvmName("mxrrquynvmxwasjc")
    public suspend fun maintainanceCostPercentageToAcquisitionCost(`value`: Output<Double>) {
        this.maintainanceCostPercentageToAcquisitionCost = value
    }

    /**
     * @param value Cost per gigabyte per month.
     */
    @JvmName("eercfcplhgbwrxho")
    public suspend fun costPerGbPerMonth(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.costPerGbPerMonth = mapped
    }

    /**
     * @param value Maintenance cost percentage.
     */
    @JvmName("rafagbobcwkklqfr")
    public suspend fun maintainanceCostPercentageToAcquisitionCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintainanceCostPercentageToAcquisitionCost = mapped
    }

    internal fun build(): StorageSettingsArgs = StorageSettingsArgs(
        costPerGbPerMonth = costPerGbPerMonth ?: throw PulumiNullFieldException("costPerGbPerMonth"),
        maintainanceCostPercentageToAcquisitionCost = maintainanceCostPercentageToAcquisitionCost ?: throw
            PulumiNullFieldException("maintainanceCostPercentageToAcquisitionCost"),
    )
}
