@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SubnetResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the virtual network subnets resource settings.
 * @property addressPrefix Gets or sets address prefix for the subnet.
 * @property name Gets or sets the Subnet name.
 * @property networkSecurityGroup Defines reference to NSG.
 */
public data class SubnetResourceSettingsArgs(
    public val addressPrefix: Output<String>? = null,
    public val name: Output<String>? = null,
    public val networkSecurityGroup: Output<NsgReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SubnetResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SubnetResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SubnetResourceSettingsArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .networkSecurityGroup(
                networkSecurityGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SubnetResourceSettingsArgs].
 */
@PulumiTagMarker
public class SubnetResourceSettingsArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var name: Output<String>? = null

    private var networkSecurityGroup: Output<NsgReferenceArgs>? = null

    /**
     * @param value Gets or sets address prefix for the subnet.
     */
    @JvmName("oyytfpfrxtwphxms")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Gets or sets the Subnet name.
     */
    @JvmName("cuaggqvdnbegorkt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Defines reference to NSG.
     */
    @JvmName("kxqwaaxbhrnsdqgw")
    public suspend fun networkSecurityGroup(`value`: Output<NsgReferenceArgs>) {
        this.networkSecurityGroup = value
    }

    /**
     * @param value Gets or sets address prefix for the subnet.
     */
    @JvmName("uewpqloxjmqwodnm")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Gets or sets the Subnet name.
     */
    @JvmName("cxuixdkfifyhtvgx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Defines reference to NSG.
     */
    @JvmName("xmllhntfjedoeaya")
    public suspend fun networkSecurityGroup(`value`: NsgReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityGroup = mapped
    }

    /**
     * @param argument Defines reference to NSG.
     */
    @JvmName("gbtembtgferjuuim")
    public suspend fun networkSecurityGroup(argument: suspend NsgReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = NsgReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkSecurityGroup = mapped
    }

    internal fun build(): SubnetResourceSettingsArgs = SubnetResourceSettingsArgs(
        addressPrefix = addressPrefix,
        name = name,
        networkSecurityGroup = networkSecurityGroup,
    )
}
