@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VirtualizationSoftwareSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Virtualization software settings.
 * @property licenseAndSupportList Licence and support list.
 * @property numberOfPhysicalCoresPerLicense Number of physical cores per licence.
 * @property softwareAssuranceCost Software Assurance cost.
 */
public data class VirtualizationSoftwareSettingsArgs(
    public val licenseAndSupportList: Output<List<VsphereLicenseArgs>>,
    public val numberOfPhysicalCoresPerLicense: Output<Int>,
    public val softwareAssuranceCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VirtualizationSoftwareSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VirtualizationSoftwareSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.VirtualizationSoftwareSettingsArgs.builder()
            .licenseAndSupportList(
                licenseAndSupportList.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .numberOfPhysicalCoresPerLicense(numberOfPhysicalCoresPerLicense.applyValue({ args0 -> args0 }))
            .softwareAssuranceCost(softwareAssuranceCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualizationSoftwareSettingsArgs].
 */
@PulumiTagMarker
public class VirtualizationSoftwareSettingsArgsBuilder internal constructor() {
    private var licenseAndSupportList: Output<List<VsphereLicenseArgs>>? = null

    private var numberOfPhysicalCoresPerLicense: Output<Int>? = null

    private var softwareAssuranceCost: Output<Double>? = null

    /**
     * @param value Licence and support list.
     */
    @JvmName("iradfepljyweeuvm")
    public suspend fun licenseAndSupportList(`value`: Output<List<VsphereLicenseArgs>>) {
        this.licenseAndSupportList = value
    }

    @JvmName("kykqtlfuqgpqouet")
    public suspend fun licenseAndSupportList(vararg values: Output<VsphereLicenseArgs>) {
        this.licenseAndSupportList = Output.all(values.asList())
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("gaexguwymxjniiwm")
    public suspend fun licenseAndSupportList(values: List<Output<VsphereLicenseArgs>>) {
        this.licenseAndSupportList = Output.all(values)
    }

    /**
     * @param value Number of physical cores per licence.
     */
    @JvmName("bkvoxdjxvqpcirtc")
    public suspend fun numberOfPhysicalCoresPerLicense(`value`: Output<Int>) {
        this.numberOfPhysicalCoresPerLicense = value
    }

    /**
     * @param value Software Assurance cost.
     */
    @JvmName("imioiiesrtxmsooj")
    public suspend fun softwareAssuranceCost(`value`: Output<Double>) {
        this.softwareAssuranceCost = value
    }

    /**
     * @param value Licence and support list.
     */
    @JvmName("fqaarklftofxauij")
    public suspend fun licenseAndSupportList(`value`: List<VsphereLicenseArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("tfoydvylmixhydwb")
    public suspend
    fun licenseAndSupportList(argument: List<suspend VsphereLicenseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VsphereLicenseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("dljgncpqfmmddlju")
    public suspend fun licenseAndSupportList(
        vararg
        argument: suspend VsphereLicenseArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VsphereLicenseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param argument Licence and support list.
     */
    @JvmName("nvmmmlobstvufskj")
    public suspend fun licenseAndSupportList(argument: suspend VsphereLicenseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VsphereLicenseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.licenseAndSupportList = mapped
    }

    /**
     * @param values Licence and support list.
     */
    @JvmName("wtinetklmlkwrxvu")
    public suspend fun licenseAndSupportList(vararg values: VsphereLicenseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseAndSupportList = mapped
    }

    /**
     * @param value Number of physical cores per licence.
     */
    @JvmName("hjvbkqqjtuaaqedy")
    public suspend fun numberOfPhysicalCoresPerLicense(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.numberOfPhysicalCoresPerLicense = mapped
    }

    /**
     * @param value Software Assurance cost.
     */
    @JvmName("kvfbhfffrgimxseq")
    public suspend fun softwareAssuranceCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceCost = mapped
    }

    internal fun build(): VirtualizationSoftwareSettingsArgs = VirtualizationSoftwareSettingsArgs(
        licenseAndSupportList = licenseAndSupportList ?: throw
            PulumiNullFieldException("licenseAndSupportList"),
        numberOfPhysicalCoresPerLicense = numberOfPhysicalCoresPerLicense ?: throw
            PulumiNullFieldException("numberOfPhysicalCoresPerLicense"),
        softwareAssuranceCost = softwareAssuranceCost ?: throw
            PulumiNullFieldException("softwareAssuranceCost"),
    )
}
