@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.VsphereManagementLicenseArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.VsphereManagementLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Representation of a vsphere management licence.
 * @property basicSupportCost Basic support cost.
 * @property licenseCost Cost of a licence.
 * @property licenseType VSphere licence type.
 * @property productionSupportCost Production support cost.
 */
public data class VsphereManagementLicenseArgs(
    public val basicSupportCost: Output<Double>,
    public val licenseCost: Output<Double>,
    public val licenseType: Output<Either<String, VsphereManagementLicenseType>>,
    public val productionSupportCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.VsphereManagementLicenseArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.VsphereManagementLicenseArgs =
        com.pulumi.azurenative.migrate.inputs.VsphereManagementLicenseArgs.builder()
            .basicSupportCost(basicSupportCost.applyValue({ args0 -> args0 }))
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .productionSupportCost(productionSupportCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VsphereManagementLicenseArgs].
 */
@PulumiTagMarker
public class VsphereManagementLicenseArgsBuilder internal constructor() {
    private var basicSupportCost: Output<Double>? = null

    private var licenseCost: Output<Double>? = null

    private var licenseType: Output<Either<String, VsphereManagementLicenseType>>? = null

    private var productionSupportCost: Output<Double>? = null

    /**
     * @param value Basic support cost.
     */
    @JvmName("yarlihlarfanughb")
    public suspend fun basicSupportCost(`value`: Output<Double>) {
        this.basicSupportCost = value
    }

    /**
     * @param value Cost of a licence.
     */
    @JvmName("cowhpncpvfdvsqyb")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("yifukrradpmbrkmw")
    public suspend fun licenseType(`value`: Output<Either<String, VsphereManagementLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Production support cost.
     */
    @JvmName("edtmxdeikclvbnmj")
    public suspend fun productionSupportCost(`value`: Output<Double>) {
        this.productionSupportCost = value
    }

    /**
     * @param value Basic support cost.
     */
    @JvmName("jhidcnjuxasnlpkb")
    public suspend fun basicSupportCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.basicSupportCost = mapped
    }

    /**
     * @param value Cost of a licence.
     */
    @JvmName("vbiekftyectqxboy")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("enqaubrmhmcgkhlj")
    public suspend fun licenseType(`value`: Either<String, VsphereManagementLicenseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("howlgaytaimjlflx")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, VsphereManagementLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value VSphere licence type.
     */
    @JvmName("dddcgldfteptjsdm")
    public fun licenseType(`value`: VsphereManagementLicenseType) {
        val toBeMapped = Either.ofRight<String, VsphereManagementLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Production support cost.
     */
    @JvmName("ieifejjwofmfksas")
    public suspend fun productionSupportCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.productionSupportCost = mapped
    }

    internal fun build(): VsphereManagementLicenseArgs = VsphereManagementLicenseArgs(
        basicSupportCost = basicSupportCost ?: throw PulumiNullFieldException("basicSupportCost"),
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        licenseType = licenseType ?: throw PulumiNullFieldException("licenseType"),
        productionSupportCost = productionSupportCost ?: throw
            PulumiNullFieldException("productionSupportCost"),
    )
}
