@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WebApplicationFrameworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Framework specific data for a web application.
 * @property name Gets or sets Name of the framework.
 * @property version Gets or sets Version of the framework.
 */
public data class WebApplicationFrameworkArgs(
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WebApplicationFrameworkArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WebApplicationFrameworkArgs =
        com.pulumi.azurenative.migrate.inputs.WebApplicationFrameworkArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebApplicationFrameworkArgs].
 */
@PulumiTagMarker
public class WebApplicationFrameworkArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Gets or sets Name of the framework.
     */
    @JvmName("hpffgxawmdktrdgl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets Version of the framework.
     */
    @JvmName("cmkuvydsyqiifopb")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets or sets Name of the framework.
     */
    @JvmName("uinuxgullvvjeoji")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets Version of the framework.
     */
    @JvmName("jlrctvjmabsbgpgj")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): WebApplicationFrameworkArgs = WebApplicationFrameworkArgs(
        name = name,
        version = version,
    )
}
