@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WindowsServerLicensingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Windows Server licensing settings.
 * @property licenseCost Licence Cost.
 * @property licensesPerCore Licenses per core.
 * @property softwareAssuranceCost Software assurance (SA) cost.
 */
public data class WindowsServerLicensingSettingsArgs(
    public val licenseCost: Output<Double>,
    public val licensesPerCore: Output<Int>,
    public val softwareAssuranceCost: Output<Double>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WindowsServerLicensingSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WindowsServerLicensingSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.WindowsServerLicensingSettingsArgs.builder()
            .licenseCost(licenseCost.applyValue({ args0 -> args0 }))
            .licensesPerCore(licensesPerCore.applyValue({ args0 -> args0 }))
            .softwareAssuranceCost(softwareAssuranceCost.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsServerLicensingSettingsArgs].
 */
@PulumiTagMarker
public class WindowsServerLicensingSettingsArgsBuilder internal constructor() {
    private var licenseCost: Output<Double>? = null

    private var licensesPerCore: Output<Int>? = null

    private var softwareAssuranceCost: Output<Double>? = null

    /**
     * @param value Licence Cost.
     */
    @JvmName("xpvtubdlfxsxrtho")
    public suspend fun licenseCost(`value`: Output<Double>) {
        this.licenseCost = value
    }

    /**
     * @param value Licenses per core.
     */
    @JvmName("ggcrynbhiybqmpem")
    public suspend fun licensesPerCore(`value`: Output<Int>) {
        this.licensesPerCore = value
    }

    /**
     * @param value Software assurance (SA) cost.
     */
    @JvmName("klqvkovseyjfftel")
    public suspend fun softwareAssuranceCost(`value`: Output<Double>) {
        this.softwareAssuranceCost = value
    }

    /**
     * @param value Licence Cost.
     */
    @JvmName("cihtnmspvcirosqk")
    public suspend fun licenseCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseCost = mapped
    }

    /**
     * @param value Licenses per core.
     */
    @JvmName("hrrcurkrrdphethv")
    public suspend fun licensesPerCore(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licensesPerCore = mapped
    }

    /**
     * @param value Software assurance (SA) cost.
     */
    @JvmName("tyadmukwlajqwoyv")
    public suspend fun softwareAssuranceCost(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceCost = mapped
    }

    internal fun build(): WindowsServerLicensingSettingsArgs = WindowsServerLicensingSettingsArgs(
        licenseCost = licenseCost ?: throw PulumiNullFieldException("licenseCost"),
        licensesPerCore = licensesPerCore ?: throw PulumiNullFieldException("licensesPerCore"),
        softwareAssuranceCost = softwareAssuranceCost ?: throw
            PulumiNullFieldException("softwareAssuranceCost"),
    )
}
