@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workload instance model properties.
 * @property customProperties Workload instance model custom properties.
 * @property displayName Gets or sets the display name.
 * @property masterSiteName Gets or Sets the master site name.
 * @property migrateAgentId Gets or sets the migrate agent id associated with the workload instance.
 * @property name Gets or sets the workload instance name.
 * @property sourceName Gets or sets the source name.
 * @property sourcePlatform Gets or sets the source platform.
 */
public data class WorkloadInstanceModelPropertiesArgs(
    public val customProperties:
    Output<Either<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs, IISWorkloadInstanceModelCustomPropertiesArgs>>? =
        null,
    public val displayName: Output<String>? = null,
    public val masterSiteName: Output<String>? = null,
    public val migrateAgentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sourceName: Output<String>? = null,
    public val sourcePlatform: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.WorkloadInstanceModelPropertiesArgs.builder()
            .customProperties(
                customProperties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .masterSiteName(masterSiteName?.applyValue({ args0 -> args0 }))
            .migrateAgentId(migrateAgentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceName(sourceName?.applyValue({ args0 -> args0 }))
            .sourcePlatform(sourcePlatform?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkloadInstanceModelPropertiesArgs].
 */
@PulumiTagMarker
public class WorkloadInstanceModelPropertiesArgsBuilder internal constructor() {
    private var customProperties:
        Output<Either<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs, IISWorkloadInstanceModelCustomPropertiesArgs>>? =
        null

    private var displayName: Output<String>? = null

    private var masterSiteName: Output<String>? = null

    private var migrateAgentId: Output<String>? = null

    private var name: Output<String>? = null

    private var sourceName: Output<String>? = null

    private var sourcePlatform: Output<String>? = null

    /**
     * @param value Workload instance model custom properties.
     */
    @JvmName("mofkogsoyfwmjgfa")
    public suspend
    fun customProperties(`value`: Output<Either<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs, IISWorkloadInstanceModelCustomPropertiesArgs>>) {
        this.customProperties = value
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("hhyvfyijltylhjan")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Gets or Sets the master site name.
     */
    @JvmName("obwmjiuhlshvpgcp")
    public suspend fun masterSiteName(`value`: Output<String>) {
        this.masterSiteName = value
    }

    /**
     * @param value Gets or sets the migrate agent id associated with the workload instance.
     */
    @JvmName("byhrhgenmyaomflu")
    public suspend fun migrateAgentId(`value`: Output<String>) {
        this.migrateAgentId = value
    }

    /**
     * @param value Gets or sets the workload instance name.
     */
    @JvmName("vryvmcujeyyjmwct")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the source name.
     */
    @JvmName("gtldfedvfvquguvb")
    public suspend fun sourceName(`value`: Output<String>) {
        this.sourceName = value
    }

    /**
     * @param value Gets or sets the source platform.
     */
    @JvmName("gbfkwfbnfbegktbe")
    public suspend fun sourcePlatform(`value`: Output<String>) {
        this.sourcePlatform = value
    }

    /**
     * @param value Workload instance model custom properties.
     */
    @JvmName("cefqtjapvgdfxeim")
    public suspend
    fun customProperties(`value`: Either<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs, IISWorkloadInstanceModelCustomPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Workload instance model custom properties.
     */
    @JvmName("idnwlqitmkfdfasv")
    public fun customProperties(`value`: ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofLeft<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs,
            IISWorkloadInstanceModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Workload instance model custom properties.
     */
    @JvmName("qjjmjrfftqurctut")
    public fun customProperties(`value`: IISWorkloadInstanceModelCustomPropertiesArgs) {
        val toBeMapped = Either.ofRight<ApacheTomcatWorkloadInstanceModelCustomPropertiesArgs,
            IISWorkloadInstanceModelCustomPropertiesArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customProperties = mapped
    }

    /**
     * @param value Gets or sets the display name.
     */
    @JvmName("pdknorikpdklncat")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Gets or Sets the master site name.
     */
    @JvmName("djnsynmejnawvqqg")
    public suspend fun masterSiteName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterSiteName = mapped
    }

    /**
     * @param value Gets or sets the migrate agent id associated with the workload instance.
     */
    @JvmName("giqfnamgludljkpw")
    public suspend fun migrateAgentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateAgentId = mapped
    }

    /**
     * @param value Gets or sets the workload instance name.
     */
    @JvmName("yluferricfcqfvws")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the source name.
     */
    @JvmName("eyosxtiheejrkgfw")
    public suspend fun sourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceName = mapped
    }

    /**
     * @param value Gets or sets the source platform.
     */
    @JvmName("vbadmvvesxltjhwj")
    public suspend fun sourcePlatform(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePlatform = mapped
    }

    internal fun build(): WorkloadInstanceModelPropertiesArgs = WorkloadInstanceModelPropertiesArgs(
        customProperties = customProperties,
        displayName = displayName,
        masterSiteName = masterSiteName,
        migrateAgentId = migrateAgentId,
        name = name,
        sourceName = sourceName,
        sourcePlatform = sourcePlatform,
    )
}
