@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * ApacheTomcat web application.
 * @property automationArtifactProperties Class for automation artifact.
 * @property bindings Gets or sets the bindings for the application.
 * @property buildContainerImages Gets or sets the build container images.
 * @property clusterProperties Class for AKSDeployment Properties.
 * @property configurations Gets or sets application configuration.
 * @property containerImageProperties Class for container image properties.
 * @property deploymentHistory Gets or sets the deployment history.
 * @property deploymentNamePrefix Gets or sets the deployment name prefix.
 * @property deploymentSpec AKS Deployment Specification.
 * @property directories Gets or sets application directories.
 * @property limits Resource Requirements.
 * @property monitoringProperties Class for app insight monitoring properties.
 * @property requests Resource Requirements.
 * @property targetPlatformIdentity Gets or sets the target platform managed identity.
 */
public data class ApacheTomcatAKSWorkloadDeploymentResponse(
    public val automationArtifactProperties: AutomationArtifactResponse? = null,
    public val bindings: List<BindingResponse>? = null,
    public val buildContainerImages: List<ContainerImagePropertiesResponse>? = null,
    public val clusterProperties: AKSDeploymentPropertiesResponse? = null,
    public val configurations: List<WebApplicationConfigurationResponse>? = null,
    public val containerImageProperties: ContainerImagePropertiesResponse? = null,
    public val deploymentHistory: List<DeployedResourcesPropertiesResponse>,
    public val deploymentNamePrefix: String? = null,
    public val deploymentSpec: AKSDeploymentSpecificationResponse? = null,
    public val directories: List<WebApplicationDirectoryResponse>? = null,
    public val limits: ResourceRequirementsResponse? = null,
    public val monitoringProperties: AppInsightMonitoringPropertiesResponse? = null,
    public val requests: ResourceRequirementsResponse? = null,
    public val targetPlatformIdentity: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ApacheTomcatAKSWorkloadDeploymentResponse):
            ApacheTomcatAKSWorkloadDeploymentResponse = ApacheTomcatAKSWorkloadDeploymentResponse(
            automationArtifactProperties = javaType.automationArtifactProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AutomationArtifactResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bindings = javaType.bindings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.BindingResponse.Companion.toKotlin(args0)
                })
            }),
            buildContainerImages = javaType.buildContainerImages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ContainerImagePropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            clusterProperties = javaType.clusterProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AKSDeploymentPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            configurations = javaType.configurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            containerImageProperties = javaType.containerImageProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ContainerImagePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentHistory = javaType.deploymentHistory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DeployedResourcesPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            deploymentNamePrefix = javaType.deploymentNamePrefix().map({ args0 -> args0 }).orElse(null),
            deploymentSpec = javaType.deploymentSpec().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AKSDeploymentSpecificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            directories = javaType.directories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WebApplicationDirectoryResponse.Companion.toKotlin(args0)
                })
            }),
            limits = javaType.limits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            monitoringProperties = javaType.monitoringProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.AppInsightMonitoringPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            requests = javaType.requests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            targetPlatformIdentity = javaType.targetPlatformIdentity().map({ args0 -> args0 }).orElse(null),
        )
    }
}
