@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * Compute settings.
 * @property hyperthreadCoreToMemoryRatio Hyperthread core to memory ratio.
 * @property price Compute Price.
 * @property rhelLinuxServerLicensing Linux Rhel Server licensing settings.
 * @property sqlServerLicensing SQL Server licensing settings.
 * @property suseLinuxServerLicensing Linux Suse Server licensing settings.
 * @property virtualizationSoftwareSettings Virtualization software settings.
 * @property windowsServerLicensing Windows Server licensing settings.
 */
public data class ComputeSettingsResponse(
    public val hyperthreadCoreToMemoryRatio: Double,
    public val price: Double,
    public val rhelLinuxServerLicensing: LinuxServerLicensingSettingsResponse,
    public val sqlServerLicensing: List<SqlServerLicensingSettingsResponse>,
    public val suseLinuxServerLicensing: LinuxServerLicensingSettingsResponse,
    public val virtualizationSoftwareSettings: VirtualizationSoftwareSettingsResponse,
    public val windowsServerLicensing: WindowsServerLicensingSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ComputeSettingsResponse):
            ComputeSettingsResponse = ComputeSettingsResponse(
            hyperthreadCoreToMemoryRatio = javaType.hyperthreadCoreToMemoryRatio(),
            price = javaType.price(),
            rhelLinuxServerLicensing = javaType.rhelLinuxServerLicensing().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.LinuxServerLicensingSettingsResponse.Companion.toKotlin(args0)
            }),
            sqlServerLicensing = javaType.sqlServerLicensing().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SqlServerLicensingSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            suseLinuxServerLicensing = javaType.suseLinuxServerLicensing().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.LinuxServerLicensingSettingsResponse.Companion.toKotlin(args0)
            }),
            virtualizationSoftwareSettings = javaType.virtualizationSoftwareSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.VirtualizationSoftwareSettingsResponse.Companion.toKotlin(args0)
            }),
            windowsServerLicensing = javaType.windowsServerLicensing().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.WindowsServerLicensingSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
