@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Class to represent the component of the cost.
 * @property description The textual description of the component.
 * @property name Gets the name of the component.
 * @property value The value of the component.
 */
public data class CostComponentResponse(
    public val description: String? = null,
    public val name: String,
    public val `value`: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.CostComponentResponse):
            CostComponentResponse = CostComponentResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
