@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines Private endpoint proxy resource.
 * @property eTag
 * @property id
 * @property name
 * @property properties Properties of a private endpoint connection proxy.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type
 */
public data class GetPrivateEndpointConnectionProxyControllerResult(
    public val eTag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: PrivateEndpointConnectionProxyPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetPrivateEndpointConnectionProxyControllerResult):
            GetPrivateEndpointConnectionProxyControllerResult =
            GetPrivateEndpointConnectionProxyControllerResult(
                eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionProxyPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
