@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class representing the config for the solution in the migrate project.
 * @property publisherSasUri Gets or sets the publisher sas uri for the solution.
 */
public data class GetSolutionConfigResult(
    public val publisherSasUri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetSolutionConfigResult):
            GetSolutionConfigResult = GetSolutionConfigResult(
            publisherSasUri = javaType.publisherSasUri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
