@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * SQL Assessment REST resource.
 * @property assessmentType Assessment type of the assessment.
 * @property asyncCommitModeIntent Gets or sets user preference indicating intent of async commit mode.
 * @property azureLocation Azure Location or Azure region where to which the machines will be migrated.
 * @property azureOfferCode Azure Offer Code.
 * @property azureOfferCodeForVm Gets or sets Azure Offer Code for VM.
 * @property azureSecurityOfferingType Gets or sets a value indicating azure security offering type.
 * @property azureSqlDatabaseSettings Gets or sets user configurable SQL database settings.
 * @property azureSqlManagedInstanceSettings Gets or sets user configurable SQL managed instance settings.
 * @property azureSqlVmSettings Gets or sets user configurable SQL VM settings.
 * @property confidenceRatingInPercentage Confidence Rating in Percentage.
 * @property createdTimestamp Date and Time when assessment was created.
 * @property currency Currency in which prices should be reported.
 * @property disasterRecoveryLocation Gets or sets the Azure Location or Azure region where to which the machines
 * will be migrated.
 * @property discountPercentage Custom discount percentage.
 * @property eaSubscriptionId Gets or sets the Enterprise agreement subscription id.
 * @property enableHadrAssessment Gets or sets a value indicating whether HADR assessments needs to be created.
 * @property entityUptime Gets or sets the duration for which the entity (SQL, VMs) are up in the
 * on-premises environment.
 * @property environmentType Gets or sets user configurable setting to display the environment type.
 * @property groupType Gets the group type for the assessment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isInternetAccessAvailable Gets or sets a value indicating whether internet access is available.
 * @property multiSubnetIntent Gets or sets user preference indicating intent of multi-subnet configuration.
 * @property name The name of the resource
 * @property optimizationLogic Gets or sets SQL optimization logic.
 * @property osLicense Gets or sets user configurable setting to display the azure hybrid use benefit.
 * @property percentile Percentile of the utilization data values to be considered while assessing
 * machines.
 * @property perfDataEndTime Gets or sets the end time to consider performance data for assessment.
 * @property perfDataStartTime Gets or sets the start time to consider performance data for assessment.
 * @property pricesTimestamp Last time when rates were queried.
 * @property provisioningState The status of the last operation.
 * @property reservedInstance Reserved instance.
 * @property reservedInstanceForVm Gets or sets azure reserved instance for VM.
 * @property scalingFactor Percentage of buffer that user wants on performance metrics when recommending
 * Azure sizes.
 * @property schemaVersion Schema version.
 * @property sizingCriterion Assessment sizing criterion.
 * @property sqlServerLicense SQL server license.
 * @property stage User configurable setting to display the Stage of Assessment.
 * @property status Whether assessment is in valid state and all machines have been assessed.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property timeRange Time Range for which the historic utilization data should be considered for
 * assessment.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Date and Time when assessment was last updated.
 */
public data class GetSqlAssessmentV2OperationResult(
    public val assessmentType: String? = null,
    public val asyncCommitModeIntent: String? = null,
    public val azureLocation: String? = null,
    public val azureOfferCode: String? = null,
    public val azureOfferCodeForVm: String? = null,
    public val azureSecurityOfferingType: String? = null,
    public val azureSqlDatabaseSettings: SqlDbSettingsResponse? = null,
    public val azureSqlManagedInstanceSettings: SqlMiSettingsResponse? = null,
    public val azureSqlVmSettings: SqlVmSettingsResponse? = null,
    public val confidenceRatingInPercentage: Double? = null,
    public val createdTimestamp: String,
    public val currency: String? = null,
    public val disasterRecoveryLocation: String? = null,
    public val discountPercentage: Double? = null,
    public val eaSubscriptionId: String? = null,
    public val enableHadrAssessment: Boolean? = null,
    public val entityUptime: EntityUptimeResponse? = null,
    public val environmentType: String? = null,
    public val groupType: String? = null,
    public val id: String,
    public val isInternetAccessAvailable: Boolean? = null,
    public val multiSubnetIntent: String? = null,
    public val name: String,
    public val optimizationLogic: String? = null,
    public val osLicense: String? = null,
    public val percentile: String? = null,
    public val perfDataEndTime: String? = null,
    public val perfDataStartTime: String? = null,
    public val pricesTimestamp: String,
    public val provisioningState: String? = null,
    public val reservedInstance: String? = null,
    public val reservedInstanceForVm: String? = null,
    public val scalingFactor: Double? = null,
    public val schemaVersion: String,
    public val sizingCriterion: String? = null,
    public val sqlServerLicense: String? = null,
    public val stage: String,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val timeRange: String? = null,
    public val type: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetSqlAssessmentV2OperationResult):
            GetSqlAssessmentV2OperationResult = GetSqlAssessmentV2OperationResult(
            assessmentType = javaType.assessmentType().map({ args0 -> args0 }).orElse(null),
            asyncCommitModeIntent = javaType.asyncCommitModeIntent().map({ args0 -> args0 }).orElse(null),
            azureLocation = javaType.azureLocation().map({ args0 -> args0 }).orElse(null),
            azureOfferCode = javaType.azureOfferCode().map({ args0 -> args0 }).orElse(null),
            azureOfferCodeForVm = javaType.azureOfferCodeForVm().map({ args0 -> args0 }).orElse(null),
            azureSecurityOfferingType = javaType.azureSecurityOfferingType().map({ args0 ->
                args0
            }).orElse(null),
            azureSqlDatabaseSettings = javaType.azureSqlDatabaseSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SqlDbSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureSqlManagedInstanceSettings = javaType.azureSqlManagedInstanceSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SqlMiSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            azureSqlVmSettings = javaType.azureSqlVmSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SqlVmSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            confidenceRatingInPercentage = javaType.confidenceRatingInPercentage().map({ args0 ->
                args0
            }).orElse(null),
            createdTimestamp = javaType.createdTimestamp(),
            currency = javaType.currency().map({ args0 -> args0 }).orElse(null),
            disasterRecoveryLocation = javaType.disasterRecoveryLocation().map({ args0 -> args0 }).orElse(null),
            discountPercentage = javaType.discountPercentage().map({ args0 -> args0 }).orElse(null),
            eaSubscriptionId = javaType.eaSubscriptionId().map({ args0 -> args0 }).orElse(null),
            enableHadrAssessment = javaType.enableHadrAssessment().map({ args0 -> args0 }).orElse(null),
            entityUptime = javaType.entityUptime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentType = javaType.environmentType().map({ args0 -> args0 }).orElse(null),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isInternetAccessAvailable = javaType.isInternetAccessAvailable().map({ args0 ->
                args0
            }).orElse(null),
            multiSubnetIntent = javaType.multiSubnetIntent().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            optimizationLogic = javaType.optimizationLogic().map({ args0 -> args0 }).orElse(null),
            osLicense = javaType.osLicense().map({ args0 -> args0 }).orElse(null),
            percentile = javaType.percentile().map({ args0 -> args0 }).orElse(null),
            perfDataEndTime = javaType.perfDataEndTime().map({ args0 -> args0 }).orElse(null),
            perfDataStartTime = javaType.perfDataStartTime().map({ args0 -> args0 }).orElse(null),
            pricesTimestamp = javaType.pricesTimestamp(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            reservedInstance = javaType.reservedInstance().map({ args0 -> args0 }).orElse(null),
            reservedInstanceForVm = javaType.reservedInstanceForVm().map({ args0 -> args0 }).orElse(null),
            scalingFactor = javaType.scalingFactor().map({ args0 -> args0 }).orElse(null),
            schemaVersion = javaType.schemaVersion(),
            sizingCriterion = javaType.sizingCriterion().map({ args0 -> args0 }).orElse(null),
            sqlServerLicense = javaType.sqlServerLicense().map({ args0 -> args0 }).orElse(null),
            stage = javaType.stage(),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            timeRange = javaType.timeRange().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
