@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Workload deployment model.
 * @property id Gets or sets the Id of the resource.
 * @property name Gets or sets the name of the resource.
 * @property properties Workload deployment model properties.
 * @property systemData
 * @property tags Gets or sets the resource tags.
 * @property type Gets or sets the type of the resource.
 */
public data class GetWorkloadDeploymentSecretConfigurationsResult(
    public val id: String,
    public val name: String,
    public val properties: WorkloadDeploymentModelPropertiesResponse,
    public val systemData: WorkloadDeploymentModelResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetWorkloadDeploymentSecretConfigurationsResult):
            GetWorkloadDeploymentSecretConfigurationsResult =
            GetWorkloadDeploymentSecretConfigurationsResult(
                id = javaType.id(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.WorkloadDeploymentModelResponseSystemData.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
