@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IISApplication details.
 * @property applicationPoolName Gets or sets the application pool name.
 * @property directories Gets or sets the list of directories.
 * @property enable32BitApiOnWin64 Gets or sets a value indicating whether 32 bit applications are allowed to run on 64 bit.
 * @property id Gets the ID.
 * @property managedPipelineMode Gets or sets the managed pipeline mode.
 * @property path Second level entity for virtual directories.
 * @property runtimeVersion Gets or sets the runtime version.
 */
public data class IISApplicationDetailsResponse(
    public val applicationPoolName: String? = null,
    public val directories: List<DirectoryPathResponse>? = null,
    public val enable32BitApiOnWin64: Boolean? = null,
    public val id: String,
    public val managedPipelineMode: String? = null,
    public val path: DirectoryPathResponse? = null,
    public val runtimeVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISApplicationDetailsResponse):
            IISApplicationDetailsResponse = IISApplicationDetailsResponse(
            applicationPoolName = javaType.applicationPoolName().map({ args0 -> args0 }).orElse(null),
            directories = javaType.directories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DirectoryPathResponse.Companion.toKotlin(args0)
                })
            }),
            enable32BitApiOnWin64 = javaType.enable32BitApiOnWin64().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            managedPipelineMode = javaType.managedPipelineMode().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.DirectoryPathResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            runtimeVersion = javaType.runtimeVersion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
