@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the MSI properties of the Move Collection.
 * @property principalId Gets or sets the principal id.
 * @property tenantId Gets or sets the tenant id.
 * @property type The type of identity used for the resource mover service.
 */
public data class IdentityResponse(
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IdentityResponse):
            IdentityResponse = IdentityResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
