@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties of a migrate project.
 * @property lastSummaryRefreshedTime Last summary refresh time.
 * @property privateEndpointConnections Gets the private endpoint connections.
 * @property provisioningState Provisioning state of the migrate project.
 * @property publicNetworkAccess Gets or sets the state of public network access.
 * @property refreshSummaryState Refresh summary state.
 * @property registeredTools Register tools inside project.
 * @property serviceEndpoint Service endpoint.
 * @property summary Project summary.
 * @property utilityStorageAccountId Utility storage account id.
 */
public data class MigrateProjectPropertiesResponse(
    public val lastSummaryRefreshedTime: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val refreshSummaryState: String,
    public val registeredTools: List<String>,
    public val serviceEndpoint: String? = null,
    public val summary: Map<String, Any>,
    public val utilityStorageAccountId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MigrateProjectPropertiesResponse):
            MigrateProjectPropertiesResponse = MigrateProjectPropertiesResponse(
            lastSummaryRefreshedTime = javaType.lastSummaryRefreshedTime(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            refreshSummaryState = javaType.refreshSummaryState(),
            registeredTools = javaType.registeredTools().map({ args0 -> args0 }),
            serviceEndpoint = javaType.serviceEndpoint().map({ args0 -> args0 }).orElse(null),
            summary = javaType.summary().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            utilityStorageAccountId = javaType.utilityStorageAccountId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
