@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ModernizeProject properties.
 * @property migrationConfiguration MigrationConfiguration properties.
 * @property provisioningState Gets or sets the provisioning state of the ModernizeProject.
 * @property serviceEndpoint Gets or sets the service endpoint.
 * @property serviceResourceId Gets or sets the service resource Id.
 */
public data class ModernizeProjectModelPropertiesResponse(
    public val migrationConfiguration: MigrationConfigurationResponse? = null,
    public val provisioningState: String,
    public val serviceEndpoint: String,
    public val serviceResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ModernizeProjectModelPropertiesResponse):
            ModernizeProjectModelPropertiesResponse = ModernizeProjectModelPropertiesResponse(
            migrationConfiguration = javaType.migrationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MigrationConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            serviceEndpoint = javaType.serviceEndpoint(),
            serviceResourceId = javaType.serviceResourceId(),
        )
    }
}
