@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An error response from the Azure Migrate service.
 * @property code An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
 * @property details A list of additional details about the error.
 * @property message A message describing the error, intended to be suitable for display in a user interface.
 * @property target The target of the particular error. For example, the name of the property in error.
 */
public data class MoveResourceErrorBodyResponse(
    public val code: String,
    public val details: List<MoveResourceErrorBodyResponse>,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MoveResourceErrorBodyResponse):
            MoveResourceErrorBodyResponse = MoveResourceErrorBodyResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourceErrorBodyResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
