@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines NIC IP configuration properties.
 * @property loadBalancerBackendAddressPools Gets or sets the references of the load balancer backend address pools.
 * @property loadBalancerNatRules Gets or sets the references of the load balancer NAT rules.
 * @property name Gets or sets the IP configuration name.
 * @property primary Gets or sets a value indicating whether this IP configuration is the primary.
 * @property privateIpAddress Gets or sets the private IP address of the network interface IP Configuration.
 * @property privateIpAllocationMethod Gets or sets the private IP address allocation method.
 * @property publicIp Defines reference to a public IP.
 * @property subnet Defines reference to subnet.
 */
public data class NicIpConfigurationResourceSettingsResponse(
    public val loadBalancerBackendAddressPools: List<LoadBalancerBackendAddressPoolReferenceResponse>? =
        null,
    public val loadBalancerNatRules: List<LoadBalancerNatRuleReferenceResponse>? = null,
    public val name: String? = null,
    public val primary: Boolean? = null,
    public val privateIpAddress: String? = null,
    public val privateIpAllocationMethod: String? = null,
    public val publicIp: PublicIpReferenceResponse? = null,
    public val subnet: SubnetReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.NicIpConfigurationResourceSettingsResponse):
            NicIpConfigurationResourceSettingsResponse = NicIpConfigurationResourceSettingsResponse(
            loadBalancerBackendAddressPools = javaType.loadBalancerBackendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.LoadBalancerBackendAddressPoolReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancerNatRules = javaType.loadBalancerNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.LoadBalancerNatRuleReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            privateIpAllocationMethod = javaType.privateIpAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            publicIp = javaType.publicIp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PublicIpReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.SubnetReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
