@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Suppress

/**
 * On-premise settings.
 * @property computeSettings Compute settings.
 * @property facilitySettings Facility settings.
 * @property laborSettings Labour settings.
 * @property managementSettings Management settings.
 * @property networkSettings Network settings.
 * @property securitySettings Security settings.
 * @property storageSettings Storage settings.
 */
public data class OnPremiseSettingsResponse(
    public val computeSettings: ComputeSettingsResponse,
    public val facilitySettings: FacilitySettingsResponse,
    public val laborSettings: LaborSettingsResponse,
    public val managementSettings: ManagementSettingsResponse? = null,
    public val networkSettings: NetworkSettingsResponse,
    public val securitySettings: SecuritySettingsResponse,
    public val storageSettings: StorageSettingsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.OnPremiseSettingsResponse):
            OnPremiseSettingsResponse = OnPremiseSettingsResponse(
            computeSettings = javaType.computeSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.ComputeSettingsResponse.Companion.toKotlin(args0)
            }),
            facilitySettings = javaType.facilitySettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.FacilitySettingsResponse.Companion.toKotlin(args0)
            }),
            laborSettings = javaType.laborSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.LaborSettingsResponse.Companion.toKotlin(args0)
            }),
            managementSettings = javaType.managementSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.ManagementSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkSettings = javaType.networkSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.NetworkSettingsResponse.Companion.toKotlin(args0)
            }),
            securitySettings = javaType.securitySettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SecuritySettingsResponse.Companion.toKotlin(args0)
            }),
            storageSettings = javaType.storageSettings().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.StorageSettingsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
