@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * WebApplication port mapping.
 * @property externalPort Gets or sets the External Port.
 * @property internalPort Gets or sets the Internal Port.
 */
public data class PortMappingResponse(
    public val externalPort: Int? = null,
    public val internalPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.PortMappingResponse):
            PortMappingResponse = PortMappingResponse(
            externalPort = javaType.externalPort().map({ args0 -> args0 }).orElse(null),
            internalPort = javaType.internalPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
