@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a project.
 * @property assessmentSolutionId Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
 * @property createdTimestamp Time when this project was created. Date-Time represented in ISO-8601 format.
 * @property customerStorageAccountArmId The ARM id of the storage account used for interactions when public access is disabled.
 * @property customerWorkspaceId The ARM id of service map workspace created by customer.
 * @property customerWorkspaceLocation Location of service map workspace created by customer.
 * @property lastAssessmentTimestamp Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until assessment is created.
 * @property numberOfAssessments Number of assessments created in the project.
 * @property numberOfGroups Number of groups created in the project.
 * @property numberOfMachines Number of machines in the project.
 * @property privateEndpointConnections The list of private endpoint connections to the project.
 * @property projectStatus Assessment project status.
 * @property provisioningState Provisioning state of the project.
 * @property publicNetworkAccess This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive access method.
 * @property serviceEndpoint Endpoint at which the collector agent can call agent REST API.
 * @property updatedTimestamp Time when this project was last updated. Date-Time represented in ISO-8601 format.
 */
public data class ProjectPropertiesResponse(
    public val assessmentSolutionId: String? = null,
    public val createdTimestamp: String,
    public val customerStorageAccountArmId: String? = null,
    public val customerWorkspaceId: String? = null,
    public val customerWorkspaceLocation: String? = null,
    public val lastAssessmentTimestamp: String,
    public val numberOfAssessments: Int,
    public val numberOfGroups: Int,
    public val numberOfMachines: Int,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val projectStatus: String? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val serviceEndpoint: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ProjectPropertiesResponse):
            ProjectPropertiesResponse = ProjectPropertiesResponse(
            assessmentSolutionId = javaType.assessmentSolutionId().map({ args0 -> args0 }).orElse(null),
            createdTimestamp = javaType.createdTimestamp(),
            customerStorageAccountArmId = javaType.customerStorageAccountArmId().map({ args0 ->
                args0
            }).orElse(null),
            customerWorkspaceId = javaType.customerWorkspaceId().map({ args0 -> args0 }).orElse(null),
            customerWorkspaceLocation = javaType.customerWorkspaceLocation().map({ args0 ->
                args0
            }).orElse(null),
            lastAssessmentTimestamp = javaType.lastAssessmentTimestamp(),
            numberOfAssessments = javaType.numberOfAssessments(),
            numberOfGroups = javaType.numberOfGroups(),
            numberOfMachines = javaType.numberOfMachines(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.migrate.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            projectStatus = javaType.projectStatus().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceEndpoint = javaType.serviceEndpoint(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
